% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/decile.R
\name{decile}
\alias{decile}
\title{Create deciles of a variable}
\usage{
decile(vector, decreasing = FALSE)
}
\arguments{
\item{vector}{an integer or numeric vector}

\item{decreasing}{a logical input, which if set to \code{FALSE} puts smallest values in
       decile 1 and if set to \code{TRUE} puts smallest values in decile 10; \code{FALSE}
       is default}
}
\value{
an integer vector of decile values
}
\description{
Takes in a vector, and returns the deciles
}
\details{
\code{decile} is a convinient function to get integer deciles of an integer or
 numeric vector. By default, the smallest values are placed in the smallest decile.

 Sometimes one may want to put smallest values in the biggest decile, and for that
 the user can set the \code{decreasing} argument to \code{TRUE}; by default it is
 \code{FALSE}.
}
\examples{
# Scores vector
scores <- c(1, 4, 7, 10, 15, 21, 25, 27, 32, 35,
            49, 60, 75, 23, 45, 86, 26, 38, 34, 67)

# Create deciles based on the values of the vector
decileScores <- decile(vector = scores)
decileScores <- decile(vector = scores, decreasing = TRUE)
}
\author{
Akash Jain
}
\seealso{
\code{\link{pentile}}, \code{\link{outliers}}, \code{\link{imputemiss}}
}

