\name{mrsfield.comp.thresh.global}
\alias{mrsfield.comp.thresh.global}
\title{Generation of Detailed Fields by Global Thresholding}
\description{
This function generates detailed fields based on global thresholding of SW coefficients.
}
\usage{
mrsfield.comp.thresh.global(grid, coef, site, netlab, eta, lam,
K, type)
}
\arguments{
\item{grid}{grid points of extrapolation sites in radian}
\item{coef}{coefficients of multi-scale SBF's}
\item{site}{grid points of observation sites in radian}
\item{netlab}{vector of labels representing sub-networks} 
\item{eta}{bandwidth parameters for Poisson kernel} 
\item{lam}{thresholding value}
\item{K}{the number of resolution levels to be thresholded in the decomposition}
\item{type}{the type of thresholding. This can be `"universal"', `"probability"', `"fdr"', `"Lorentz"' and `"sure"'.}
}
\value{ 
\item{dfield}{detailed fields generated by global thresholding}
}
\references{
Oh, H-S. (1999)  Spherical wavelets and their statistical analysis with applications to meteorological data. Ph.D. Thesis, 
Department of Statistics, Texas A\&M University, College Station.

Oh, H-S. and Li, T-H. (2004) Estimation of global temperature fields from scattered observations by 
a spherical-wavelet-based spatially adaptive method. \emph{Journal of the Royal Statistical Society
Ser.} B, \bold{66}, 221--238.
}
\seealso{
\code{\link{sbf}}, \code{\link{swd}}, \code{\link{swthresh}}, \code{\link{swr}}
}
\keyword{nonparametric}
