% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{cluster_similarity}
\alias{cluster_similarity}
\title{cluster_similarity: cluster a similarity matrix using the Ng method}
\usage{
cluster_similarity(A2, k = k, clusteralg = "GMM", specalg = "Ng")
}
\arguments{
\item{A2}{Data frame or matrix: a similarity matrix}

\item{k}{Numerical value: the number of clusters}

\item{clusteralg}{Character value: GMM or km clustering algorithm (suggested=GMM)}

\item{specalg}{Character value: Ng or Melia variant of spectral clustering (default=Ng)}
}
\value{
A numeric vector of cluster assignments
}
\description{
This function performs clustering of a similarity matrix following the method
of Ng or of Melia. We recommend using the Ng method with GMM to cluster the 
eigenvectors instead of k-means.
}
\examples{
ng_similarity <- cluster_similarity(missl[[1]],k=8)
}
\references{
Ng, Andrew Y., Michael I. Jordan, and Yair Weiss. "On spectral clustering: 
Analysis and an algorithm." Advances in neural information processing systems. 2002.

Meila, Marina, et al. "Spectral Clustering: a Tutorial for the 2010’s." Handbook 
of Cluster Analysis. CRC Press, 2016. 1-23.
}
