% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pwd}
\alias{pwd}
\title{Product Within Distance (Spatially Balanced Sampling).}
\usage{
pwd(dis, nsamp, nrepl = 1L, niter = 10L)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs of units in the population.}

\item{nsamp}{Sample size.}

\item{nrepl}{Number of samples to draw (default = 1).}

\item{niter}{Number of iterations for the algorithm. More iterations are better but require more time. Usually 10 is very efficient (default = 10).}
}
\value{
Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
}
\description{
This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the product of distance as an index of the within sample distance (Product Within Distance, \code{pwd} in short).
To have constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, the distance matrix has to be standardized with function \code{\link{stprod}}.
Note that there is a parameter \eqn{\beta} which regulates the spread of the sample: The higher \eqn{\beta} is, the more the sample is going to be spread.
This parameter is regulated by the exponent of the distance matrix (D^1 -> \eqn{\beta = 1}, D^10 -> \eqn{\beta = 10}).
}
\examples{
# Example 1
# Draw 20 samples of dimension 15 without constant probabilities and with beta = 1
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
samples <- pwd(dis, niter, nsamp, nrepl)  # drawn samples
\donttest{
# Example 2
# Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
# with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
vec <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(dis, vec ,1e-15 ,1000) # standardized matrix
samples <- pwd(stand_dist, niter, nsamp, nrepl)  # drawn samples

# Example 3
# Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
# with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
dis <- dis^10 # setting beta = 10
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
vec <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
samples <- pwd(stand_dist, niter, nsamp, nrepl)  # drawn samples
}
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}
}
