% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hpwd}
\alias{hpwd}
\title{Heuristic Product Within Distance (Spatially Balanced Sampling).}
\usage{
hpwd(dis, nsamp, nrepl)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs of units in the population.}

\item{nsamp}{Sample size.}

\item{nrepl}{Number of samples drawn.}
}
\value{
Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
}
\description{
The function \code{hpwd} provides a fast selection of spatially balanced samples: it is a heuristic and a fast implemention of the algorithm \code{\link{pwd}}.
It generates samples approximately with the same probabilities of the \code{\link{pwd}} but with a significantly smaller number of steps.
In fact, this algorithm randomly selects a sample of size \eqn{n} exactly with \eqn{n} steps, updating at each step the selection probability of not-selected units, depending on their distance from the units, that were already selected in the previous steps.
Note that the inclusion probabilities are all constant and equal to \eqn{nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size.
}
\examples{
##Example 1
##Draw 50 samples of dimension 10 without constant probabilities
dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
drawn_samples<-hpwd(dis,10,50)
\donttest{
##Example 2
##Draw 100 samples of dimension 15 with constant probabilities equal to nsamp/N
#with N=population size
dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
vec<-rep(1,nrow(dis)) #vector of constraints
stand_dist<-stprod(dis,vec,1e-15,1000) #standardized matrix
drawn_samples<-hpwd(stand_dist,15,100)
}
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}

\insertRef{fast_selection}{Spbsampling}
}
