% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stewart.R
\name{contourStewart}
\alias{contourStewart}
\title{Create a SpatialPolygonsDataFrame or a SpatialLinesDataFrame from a
Stewart Raster}
\usage{
contourStewart(x, breaks, type = "line")
}
\arguments{
\item{x}{raster; output of the \code{\link{rasterStewart}} function.}

\item{breaks}{numeric; a vector of break values.}

\item{type}{character; "poly" or "line". WARNING: the poly option is experimental and needs the rgeos package.}
}
\value{
The ouput of the function is a SpatialPolygonsDataFrame (\code{type = "poly"}) or a SpatialLinesDataFrame (\code{type = "line"}).
}
\description{
This function create a SpatialPolygonsDataFrame or a SpatialLinesDataFrame from the Stewart raster.
}
\examples{
data(spatData)
# Compute Stewart potentials from known points (spatPts) on a
# grid defined by its resolution
mystewart <- stewart(knownpts = spatPts, varname = "Capacite",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 50, longlat = FALSE,
                     mask = spatMask)
# Create a raster of potentials values
mystewartraster <- rasterStewart(x = mystewart, mask = spatMask)
# Display the raster and get break values
break.values <- plotStewart(x = mystewartraster)
# Create contour SpatialLinesDataFrame
mystewartcontourlines <- contourStewart(x = mystewartraster,
                                        breaks = break.values,
                                        type = "line")
mystewartcontourlines@data
plot(mystewartcontourlines, col = "grey20", add=TRUE)
plot(spatMask, lwd = 1.25, add=TRUE)
# Create contour SpatialPolygonsDataFrame
mystewartcontourpoly<- contourStewart(x = mystewartraster,
                                      breaks = break.values,
                                      type = "poly")
unique(mystewartcontourpoly@data)
plot(spatMask, col = "grey80", border = "grey50")
plot(mystewartcontourpoly, col = "#0000ff50", border = "grey40",
     add = TRUE)
plot(spatPts, cex = 0.5, pch = 20, col  = "#ff000050", add = TRUE)
}
\seealso{
\link{stewart}, \link{rasterStewart}, \link{plotStewart}, \link{contourStewart}, \link{CreateGrid}, \link{CreateDistMatrix}.
}

