% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_nll.R
\name{r_nll}
\alias{r_nll}
\title{Calculate the negative marginal loglikelihood of the GEV-GP  model.}
\usage{
r_nll(
  y,
  dd,
  a,
  log_b,
  s,
  hyperparam_a,
  hyperparam_b,
  hyperparam_s,
  kernel = "exp",
  beta_a = NULL,
  beta_b = NULL,
  beta_s = NULL,
  X_a = NULL,
  X_b = NULL,
  X_s = NULL,
  f_s = function(x) {     x },
  ...
)
}
\arguments{
\item{y}{List of \code{n} locations each with \code{n_obs[i]} independent GEV realizations.}

\item{dd}{An \verb{n x n} distance matrix.}

\item{a}{Vector of \code{n} location paramter}

\item{log_b}{A numeric value or a vector of \code{n} log-transformed scale parameters if considered
as a random effect.}

\item{s}{A numeric value or a vector of \code{n} shape parameters}

\item{hyperparam_a}{A vector of hyperparameters for a. See details.}

\item{hyperparam_b}{A vector of hyperparameters for b. Must be provided if \code{log_b} is a vector.
See details.}

\item{hyperparam_s}{A vector of hyperparameters for f(s), where f() is a transformation function
for s specifided using the \code{f_s} argument. Must be provided if \code{s} is a vector.}

\item{kernel}{"exp" or "matern". Kernel function used to compute the covariance matrix for
spatial random effects. Default is "exp".}

\item{beta_a}{Numeric. Coefficients for mean of GP(a).}

\item{beta_b}{Numeric. Coefficients for mean of GP(log_b).}

\item{beta_s}{Numeric. Coefficients for mean of GP(s).}

\item{X_a}{Design matrix for a. If not provided, this will a \verb{n_loc x 1} column matrix of 1s.}

\item{X_b}{Design matrix for log(b). If not provided and logb is a random effect,
this will a \verb{n_loc x 1} column matrix of 1s.}

\item{X_s}{Design matrix for s. If not provided, this will a \verb{n_loc x 1} column matrix of 1s.}

\item{f_s}{A function f() used to transform s such that
f(s) ~ GP(X_s*beta_s, Sigma(hyperparam_s)). Default is identitfy function: \code{function(x){x}}.}

\item{...}{Additional arguments to pass to the kernel function, e.g. \code{nu} for the matern.}
}
\value{
Scalar value of the negative marginal loglikelihood:\preformatted{-logL(Data; spatial_random_effects, fixed_hyperparameters)
}
}
\description{
Calculate the negative marginal loglikelihood of the GEV-GP  model.
}
\details{
This function is used to test if TMB and R output the same negative loglikelihood.
If \verb{kernel="exp}, \code{hyperparam_a/b/s} should be \code{c(sigma_a/b/s, ell_a/b/s)}, where \code{sigma} is the
amplitude hyperparameter and \code{ell} is the smoothness hyperparameter for the exponential kernel.
If \verb{kernel="matern}, \code{hyperparam_a/b/s} should be \code{c(sigma_a/b, kappa_a/b/s)}, where \code{sigma} and
\code{kappa} are hyperparameters for the Matern kernel.
If only \code{a} is a spatial random effect and \code{b} is fixed, only \code{hyperparam_a} needs to be
provided.

This function is used as the ground truth for testing hpp model likelihood.
}
\examples{
library(SpatialGEV)
a <- simulatedData$a
logb <- simulatedData$logb
logs <- simulatedData$logs
s <- exp(logs)
y <- simulatedData$y
locs <- simulatedData$locs
dd <- as.matrix(stats::dist(locs))
log_sigma_a <- -1; log_ell_a <- 5
log_sigma_b <- -2; log_ell_b <- 10
beta_a <- mean(a); beta_b <- mean(logb)
# Negative marginal log-likelihood produced in R using the exponential kernel
nll_r <- r_nll(y, dd, a=a, log_b=logb, s=s,
               hyperparam_a=c(exp(log_sigma_a), exp(log_ell_a)),
               hyperparam_b=c(exp(log_sigma_b), exp(log_ell_b)),
               kernel="exp", beta_a=beta_a, beta_b=beta_b)
# Negative marg loglik produced by TMB template
init_param <- list(beta_a=beta_a, beta_b=beta_b,
                   a=a, log_b=logb, s=log(s), 
                   log_sigma_a=log_sigma_a, 
                   log_ell_a=log_ell_a,
                   log_sigma_b=log_sigma_b, 
                   log_ell_b=log_ell_b)
adfun <- spatialGEV_fit(y, locs, random="ab",
                        init_param=init_param,
                        reparam_s="positive",
                        kernel="exp",
                        adfun_only=TRUE,
                        ignore_random=TRUE,
                        silent=TRUE)
nll_tmb <- adfun$fn(unlist(init_param))
nll_r - nll_tmb
}
