% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_lattice}
\alias{plot_lattice}
\title{Plot lattice data.}
\usage{
plot_lattice(data, win = spatstat::owin(xrange = c(1, ncol(data)), yrange =
  c(1, nrow(data))), gray.ext = c(1, 0), main = "", ribbon = TRUE)
}
\arguments{
\item{data}{A matrix, can be numeric, factor, character.}

\item{win}{An \code{owin} object, the observation area (see package \code{spatstat}). Automatically
created, if not provided, by setting the pixel size as 1.}

\item{gray.ext}{A vector of length two with the two extremes of the gray scale (between 0 and 1).}

\item{main}{Optional, a character string with the plot main title.}

\item{ribbon}{Logical, whether to display a ribbon showing the colour map.}
}
\value{
A gray scale plot of the categorical lattice dataset.
}
\description{
\code{plot_lattice} produces a gray scale plot of a matrix of
categorical data.
}
\details{
This function allows to easily produce a gray scale map given a matrix of categorical data
and, optionally, the observation area. It ensures that data is displayed following the matrix order
(where position (1,1) corresponds to the top-left corner of plot), avoiding risks of row inversion or
transposition. A few #'options may be tuned: the extent of the gray scale, the title and the legend.
}
\examples{
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
plot_lattice(data.lat)

plot_lattice(data.lat, win=square(100))

plot_lattice(data.lat, win=square(10), gray.ext=c(1,.4), ribbon=FALSE)

}
