% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/couple_count.R
\name{couple_count}
\alias{couple_count}
\title{Build ordered couples in a dataset.}
\usage{
couple_count(data, adj.mat, missing.cat = NULL)
}
\arguments{
\item{data}{A matrix or vector, can be numeric, factor, character...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{adj.mat}{An adjacency matrix, upper- or lower-triangular. Provided by user or generated by \code{\link{adj_mat}}.}

\item{missing.cat}{A vector with the names of all categories that are absent in \code{data}.}
}
\value{
The number of couples, and a table with absolute and relative frequencies
for each couple of categories.
}
\description{
This function builds and counts the number of all types of ordered couples in a data vector or matrix,
according to a chosen adjacency matrix. 'Ordered' means that a couple (i,j) is
different than a couple (j,i).
}
\details{
This function needs a data matrix or data vector of any type (numeric, factor, character, ...),
and an adjacency matrix as generated by \code{\link[=adj_mat]{adj_mat()}}. It returns all the data couples
identified by the adjacency matrix, i.e. occurring at the chosen neighbourhood distance.
Relative and absolute frequencies for all possible couples are returned, and may be used
for computation of spatial entropy at the chosen distance range.
'Ordered' means that the relative spatial location is relevant, i.e. that a couple
where category \eqn{i} occurs at the left of category \eqn{j} is different from a couple
where category \eqn{j} occurs at the left of category \eqn{i}.
}
\examples{
dist.mat=euclid_dist(cbind(rep(1:5, each=5), rep(1:5,5)))
adj.mat=adj_mat(dist.mat, dd1=dist.mat[1,2]) #for the contiguity matrix
couple_count(sample(1:3, 25, replace=TRUE), adj.mat)

}
