% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{estimatepopulation}
\alias{estimatepopulation}
\title{Bootstrapping to evaluate confidence intervals using BCa methods}
\usage{
estimatepopulation(zdat, nboot = 1000, pthresh = 0.02, iseed = 1234,
  alpha = c(0.025, 0.05, 0.1, 0.16, 0.84, 0.9, 0.95, 0.975), ...)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has zero count.}

\item{nboot}{Number of bootstrap replications.}

\item{pthresh}{p-value threshold used in \code{\link{estimatepopulation.0}}.}

\item{iseed}{seed for initialisation.}

\item{alpha}{Bootstrap quantiles of interests.}

\item{...}{other arguments which will be passed to \code{\link{estimatepopulation.0}}}
}
\value{
A list with components as below:

\code{popest}  point estimate of the total population of the original data set

\code{MSEfit} model fitted to the data, in the format described in \code{\link{modelfit}}

\code{bootreps} point estimates of total population sizes from each bootstrap sample

\code{ahat} the estimated acceleration factor

\code{BCaquantiles} BCa confidence intervals
}
\description{
This routine implements the bootstrapping and jacknife approach as detailed in Section 3.3 of Chan, Silverman and Vincent (2019).
 It calls the routine \code{\link{estimatepopulation.0}} and so is the preferred routine to be called if a user wishes to estimate the
  population and obtain BCa confidence intervals.
}
\references{
Chan, L., Silverman, B. W., and Vincent, K. (2019).
 Multiple Systems Estimation for Sparse Capture Data: Inferential Challenges when there are Non-Overlapping Lists.
  Available from \url{https://arxiv.org/abs/1902.05156}.

DiCiccio, T. J. and Efron, B. (1996). Bootstrap Confidence Intervals. \emph{Statistical Science}, \strong{40(3)}, 189-228.
}
