% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{read.df}
\alias{read.df}
\alias{read.df.default}
\alias{loadDF}
\alias{loadDF.default}
\title{Load a SparkDataFrame}
\usage{
\method{read.df}{default}(path = NULL, source = NULL, schema = NULL, na.strings = "NA", ...)

\method{loadDF}{default}(path = NULL, source = NULL, schema = NULL, ...)
}
\arguments{
\item{path}{The path of files to load}

\item{source}{The name of external data source}

\item{schema}{The data schema defined in structType or a DDL-formatted string.}

\item{na.strings}{Default string value for NA when source is "csv"}

\item{...}{additional external data source specific named properties.}
}
\value{
SparkDataFrame
}
\description{
Returns the dataset in a data source as a SparkDataFrame
}
\details{
The data source is specified by the \code{source} and a set of options(...).
If \code{source} is not specified, the default data source configured by
"spark.sql.sources.default" will be used. \cr
Similar to R read.csv, when \code{source} is "csv", by default, a value of "NA" will be
interpreted as NA.
}
\note{
read.df since 1.4.0

loadDF since 1.6.0
}
\examples{
\dontrun{
sparkR.session()
df1 <- read.df("path/to/file.json", source = "json")
schema <- structType(structField("name", "string"),
                     structField("info", "map<string,double>"))
df2 <- read.df(mapTypeJsonPath, "json", schema, multiLine = TRUE)
df3 <- loadDF("data/test_table", "parquet", mergeSchema = "true")
stringSchema <- "name STRING, info MAP<STRING, DOUBLE>"
df4 <- read.df(mapTypeJsonPath, "json", stringSchema, multiLine = TRUE)
}
}
\seealso{
\link{read.json}
}
