% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_tree.R
\name{spark.randomForest}
\alias{spark.randomForest}
\alias{spark.randomForest,SparkDataFrame,formula-method}
\alias{summary,RandomForestRegressionModel-method}
\alias{print.summary.RandomForestRegressionModel}
\alias{summary,RandomForestClassificationModel-method}
\alias{print.summary.RandomForestClassificationModel}
\alias{predict,RandomForestRegressionModel-method}
\alias{predict,RandomForestClassificationModel-method}
\alias{write.ml,RandomForestRegressionModel,character-method}
\alias{write.ml,RandomForestClassificationModel,character-method}
\title{Random Forest Model for Regression and Classification}
\usage{
spark.randomForest(data, formula, ...)

\S4method{spark.randomForest}{SparkDataFrame,formula}(
  data,
  formula,
  type = c("regression", "classification"),
  maxDepth = 5,
  maxBins = 32,
  numTrees = 20,
  impurity = NULL,
  featureSubsetStrategy = "auto",
  seed = NULL,
  subsamplingRate = 1,
  minInstancesPerNode = 1,
  minInfoGain = 0,
  checkpointInterval = 10,
  maxMemoryInMB = 256,
  cacheNodeIds = FALSE,
  handleInvalid = c("error", "keep", "skip")
)

\S4method{summary}{RandomForestRegressionModel}(object)

\method{print}{summary.RandomForestRegressionModel}(x, ...)

\S4method{summary}{RandomForestClassificationModel}(object)

\method{print}{summary.RandomForestClassificationModel}(x, ...)

\S4method{predict}{RandomForestRegressionModel}(object, newData)

\S4method{predict}{RandomForestClassificationModel}(object, newData)

\S4method{write.ml}{RandomForestRegressionModel,character}(object, path, overwrite = FALSE)

\S4method{write.ml}{RandomForestClassificationModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a SparkDataFrame for training.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{type}{type of model, one of "regression" or "classification", to fit}

\item{maxDepth}{Maximum depth of the tree (>= 0).}

\item{maxBins}{Maximum number of bins used for discretizing continuous features and for choosing
how to split on features at each node. More bins give higher granularity. Must be
>= 2 and >= number of categories in any categorical feature.}

\item{numTrees}{Number of trees to train (>= 1).}

\item{impurity}{Criterion used for information gain calculation.
For regression, must be "variance". For classification, must be one of
"entropy" and "gini", default is "gini".}

\item{featureSubsetStrategy}{The number of features to consider for splits at each tree node.
Supported options: "auto" (choose automatically for task: If
                   numTrees == 1, set to "all." If numTrees > 1
                   (forest), set to "sqrt" for classification and
                   to "onethird" for regression),
                   "all" (use all features),
                   "onethird" (use 1/3 of the features),
                   "sqrt" (use sqrt(number of features)),
                   "log2" (use log2(number of features)),
                   "n": (when n is in the range (0, 1.0], use
                   n * number of features. When n is in the range
                   (1, number of features), use n features).
                   Default is "auto".}

\item{seed}{integer seed for random number generation.}

\item{subsamplingRate}{Fraction of the training data used for learning each decision tree, in
range (0, 1].}

\item{minInstancesPerNode}{Minimum number of instances each child must have after split.}

\item{minInfoGain}{Minimum information gain for a split to be considered at a tree node.}

\item{checkpointInterval}{Param for set checkpoint interval (>= 1) or disable checkpoint (-1).
Note: this setting will be ignored if the checkpoint directory is not
set.}

\item{maxMemoryInMB}{Maximum memory in MB allocated to histogram aggregation.}

\item{cacheNodeIds}{If FALSE, the algorithm will pass trees to executors to match instances with
nodes. If TRUE, the algorithm will cache node IDs for each instance. Caching
can speed up training of deeper trees. Users can set how often should the
cache be checkpointed or disable it by setting checkpointInterval.}

\item{handleInvalid}{How to handle invalid data (unseen labels or NULL values) in features and
label column of string type in classification model.
Supported options: "skip" (filter out rows with invalid data),
                   "error" (throw an error), "keep" (put invalid data in
                   a special additional bucket, at index numLabels). Default
                   is "error".}

\item{object}{A fitted Random Forest regression model or classification model.}

\item{x}{summary object of Random Forest regression model or classification model
returned by \code{summary}.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.randomForest} returns a fitted Random Forest model.

\code{summary} returns summary information of the fitted model, which is a list.
        The list of components includes \code{formula} (formula),
        \code{numFeatures} (number of features), \code{features} (list of features),
        \code{featureImportances} (feature importances), \code{maxDepth} (max depth of trees),
        \code{numTrees} (number of trees), and \code{treeWeights} (tree weights).

\code{predict} returns a SparkDataFrame containing predicted labeled in a column named
        "prediction".
}
\description{
\code{spark.randomForest} fits a Random Forest Regression model or Classification model on
a SparkDataFrame. Users can call \code{summary} to get a summary of the fitted Random Forest
model, \code{predict} to make predictions on new data, and \code{write.ml}/\code{read.ml} to
save/load fitted models.
For more details, see
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html#random-forest-regression}{
Random Forest Regression} and
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html#random-forest-classifier}{
Random Forest Classification}
}
\note{
spark.randomForest since 2.1.0

summary(RandomForestRegressionModel) since 2.1.0

print.summary.RandomForestRegressionModel since 2.1.0

summary(RandomForestClassificationModel) since 2.1.0

print.summary.RandomForestClassificationModel since 2.1.0

predict(RandomForestRegressionModel) since 2.1.0

predict(RandomForestClassificationModel) since 2.1.0

write.ml(RandomForestRegressionModel, character) since 2.1.0

write.ml(RandomForestClassificationModel, character) since 2.1.0
}
\examples{
\dontrun{
# fit a Random Forest Regression Model
df <- createDataFrame(longley)
model <- spark.randomForest(df, Employed ~ ., type = "regression", maxDepth = 5, maxBins = 16)

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)

# fit a Random Forest Classification Model
t <- as.data.frame(Titanic)
df <- createDataFrame(t)
model <- spark.randomForest(df, Survived ~ Freq + Age, "classification")
}
}
