% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\docType{methods}
\name{scheduleEvent}
\alias{scheduleEvent}
\alias{scheduleEvent,simList,NULL,character,character,numeric-method}
\alias{scheduleEvent,simList,numeric,character,character,missing-method}
\alias{scheduleEvent,simList,numeric,character,character,numeric-method}
\title{Schedule a simulation event}
\usage{
scheduleEvent(sim, eventTime, moduleName, eventType, eventPriority)

\S4method{scheduleEvent}{simList,numeric,character,character,numeric}(sim,
  eventTime, moduleName, eventType, eventPriority)

\S4method{scheduleEvent}{simList,`NULL`,character,character,numeric}(sim,
  eventTime, moduleName, eventType, eventPriority)

\S4method{scheduleEvent}{simList,numeric,character,character,missing}(sim,
  eventTime, moduleName, eventType, eventPriority)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{eventTime}{A numeric specifying the time of the next event.}

\item{moduleName}{A character string specifying the module from which to
call the event.}

\item{eventType}{A character string specifying the type of event from
within the module.}

\item{eventPriority}{A numeric specifying the priority of the event.
Lower number means higher priority.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Adds a new event to the simulation's event queue, updating the simulation object.
}
\details{
Based on code from chapter 7.8.3 of Matloff (2011): "Discrete event simulation".
Here, we implement a simulation in a more modular fashion so it's easier to add
submodules to the simulation. We use S4 classes and methods, and use `data.table`
instead of `data.frame` to implement the event queue (because it is much faster).
}
\examples{
\dontrun{
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn") # default priority
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .normal()) # default priority

 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .normal()-1) # higher priority
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .normal()+1) # lower priority

 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .highest()) # highest priority
 scheduleEvent(x, time(sim) + 1.0, "firemodule", "burn", .lowest()) # lowest priority
}
}
\author{
Alex Chubaty
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3). San Fransisco, CA: No Starch Press, Inc.. Retrieved from \url{http://www.nostarch.com/artofr.htm}
}

