% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{gaussMap}
\alias{gaussMap}
\title{Produce a \code{raster} of a random Gaussian process.}
\usage{
gaussMap(
  x,
  scale = 10,
  var = 1,
  speedup = 1,
  method = "RMexp",
  alpha = 1,
  inMemory = FALSE,
  ...
)
}
\arguments{
\item{x}{A spatial object (e.g., a \code{RasterLayer}).}

\item{scale}{The spatial scale in map units of the Gaussian pattern.}

\item{var}{Spatial variance.}

\item{speedup}{An numeric value indicating how much faster than 'normal'
to generate maps. It may be necessary to give a value larger
than 1 for large maps. Default is 1.}

\item{method}{The type of model used to produce the Gaussian pattern.
Should be one of \code{"RMgauss"} (Gaussian covariance model),
\code{"RMstable"} (the stable powered exponential model),
or the default, \code{"RMexp"} (exponential covariance model).}

\item{alpha}{A required parameter of the \code{"RMstable"} model.
Should be in the interval \verb{[0,2]} to provide a valid covariance function.
Default is 1.}

\item{inMemory}{Should the RasterLayer be forced to be in memory?
Default \code{FALSE}.}

\item{...}{Additional arguments to \code{raster}.}
}
\value{
A raster map with same extent as \code{x}, with a Gaussian random pattern.
}
\description{
Defunct.
}
