% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CenturyModel.R
\name{CenturyModel}
\alias{CenturyModel}
\title{Implementation of the Century model}
\usage{
CenturyModel(
  t,
  ks = c(STR.surface = 0.076, MET.surface = 0.28, STR.belowgroun = 0.094, MET.belowground
    = 0.35, ACT = 0.14, SLW = 0.0038, PAS = 0.00013),
  C0 = rep(0, 7),
  surfaceIn,
  soilIn,
  LN,
  Ls,
  clay = 0.2,
  silt = 0.45,
  xi = 1,
  xi_lag = 0,
  solver = deSolve.lsoda.wrapper
)
}
\arguments{
\item{t}{A vector containing the points in time where the solution is
sought.}

\item{ks}{A vector of length 7 containing the values of the decomposition
rates for the different pools. Units in per week.}

\item{C0}{A vector of length 7 containing the initial amount of carbon for
the 7 pools.}

\item{surfaceIn}{A scalar or data.frame object specifying the amount of aboveground litter
inputs to the soil surface by time (mass per area per week).}

\item{soilIn}{A scalar or data.frame object specifying the amount of belowground litter
inputs to the soil by time (mass per area per week).}

\item{LN}{A scalar representing the lignin to nitrogen ratio of the plant
residue inputs.}

\item{Ls}{A scalar representing the fraction of structural material that is
lignin.}

\item{clay}{Proportion of clay in mineral soil.}

\item{silt}{Proportion of silt in mineral soil.}

\item{xi}{A scalar, data.frame, function or anything that can be converted
to a scalar function of time \code{\linkS4class{ScalarTimeMap}}  object
specifying the external (environmental and/or edaphic) effects on
decomposition rates.}

\item{xi_lag}{A time shift/delay  for the automatically 
created time dependent function xi(t)}

\item{solver}{A function that solves the system of ODEs. This can be
\code{\link{euler}} or \code{\link{deSolve.lsoda.wrapper}} or any other user
provided function with the same interface.}
}
\value{
A Model Object that can be further queried
}
\description{
This function implements the Century model as described in Parton et al.
(1987).
}
\details{
This is one of the few examples that internally make use of
the new infrastructure for flux based descriptions of models (see examples).
}
\examples{
mnths=seq(0,100)
APPT=50 # Assume 50 cm annual precipitation
Pmax=-40+7.7*APPT # Max aboveground production
Rmax=100+7.0*APPT # Max belowground production
abvgIn=Pmax/(Pmax+Rmax)
blgIn=Rmax/(Pmax+Rmax)

cm=CenturyModel(t=mnths, surfaceIn = abvgIn, soilIn = blgIn, LN=0.5, Ls=0.1)
Ct=getC(cm)

poolNames=c("Surface structural", "Surface metabolic", "Belowground structural",
               "Belowground metabolic", "Active SOM", "Slow SOM", "Passive SOM")
matplot(mnths,Ct, type="l", lty=1, col=1:7, xlab="Time (months)", ylab="Carbon stock ")
legend("topleft", poolNames, lty=1, col=1:7, bty="n")
}
\references{
Parton, W.J, D.S. Schimel, C.V. Cole, and D.S. Ojima. 1987.
Analysis of factors controlling soil organic matter levels in Great Plain
grasslands. Soil Science Society of America Journal 51: 1173--1179. Sierra,
C.A., M. Mueller, S.E. Trumbore. 2012. Models of soil organic matter
decomposition: the SoilR package version 1.0. Geoscientific Model
Development 5, 1045-1060.
}
\seealso{
\code{\link{RothCModel}}. There are other
\code{\link{predefinedModels}} and also more general functions like
\code{\link{Model}}.
}
