% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gene_fold_changes.R
\name{get_gene_fold_changes}
\alias{get_gene_fold_changes}
\title{Get gene differential expression results for genes of interest}
\usage{
get_gene_fold_changes(
  skeletalvis,
  gene_symbols,
  return_fdr = TRUE,
  add_meta_data = TRUE
)
}
\arguments{
\item{skeletalvis}{The path to the SkeletalVis data folder.}

\item{gene_symbols}{The human gene symbols to extract fold change and FDR values for.}

\item{return_fdr}{Return FDR values (FALSE by default).}

\item{add_meta_data}{Add metadata such as species, tissue, description of overall experiment and specific comparison}
}
\value{
A tibble containing gene expression results for the specified genes.
}
\description{
Extracts the fold change and p-values across the SkeletalVis database for the specified genes.
}
\examples{
skeletalvis <- load_skeletalvis(demo=TRUE)

gene_results <- get_gene_fold_changes(skeletalvis, c("SOX9","ACAN"))

head(gene_results)
}
