% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_adapt.R
\name{site_adapt}
\alias{site_adapt}
\title{Site Adaptation of Solar Irradiance Modeled Series with Coincident Ground Measurements}
\usage{
site_adapt(
  Target,
  latitude_target,
  z_target,
  Calibration,
  latitude_calibrat,
  z_calibrat,
  timezone,
  GHI_threshold,
  DNI_threshold
)
}
\arguments{
\item{Target}{Dataframe object with solar radiation series to be adapted including time (with same time zone as subset_calibrating_period), the solar irradiance modeled series to be site adapted, along with their clear sky index and solar elevation (degrees)}

\item{latitude_target}{Site latitude of solar radiation series to be adapted (degrees, +N)}

\item{z_target}{Site elevation above sea level of solar radiation series to be adapted (m)}

\item{Calibration}{Dataframe object with solar radiation series for calibrating including time (with same time zone as subset_target_period), solar irradiance modeled and measured series, along with modeled clear sky index and solar elevation (degrees)}

\item{latitude_calibrat}{Site latitude of solar radiation series for calibrating (degrees, +N)}

\item{z_calibrat}{Site elevation above sea level of solar radiation series for calibrating (m)}

\item{timezone}{Time zone specification of the calibration_period and target_period datasets}

\item{GHI_threshold}{Upper limit of GHI series (same units that Target). For automatic calulation from observed data, set it to -99}

\item{DNI_threshold}{Upper limit of DNI series (same units that Target). For automatic calulation from observed data, set it to -99}
}
\value{
Dataframe object including time and site adapted solar irradiance series
}
\description{
Site Adaptation of Solar Irradiance Modeled Series with Coincident Ground Measurements
}
\examples{
# A site located in the the Namib Desert of Namibia (Gobabeb, GOB) is selected

# - latitude:   23.5614 S
# - Longitude:  15.0420 E
# - Elevation:  407.0 m asl

 # Load calibration and modeled datasets
   data(calibration_2016) # Measured from BSRN
   data(target_2013_2016) # Provided by CAMS-RAD service

observed_2013_2016$time = as.POSIXct(
paste(observed_2013_2016$Year, "-",
observed_2013_2016$Month, "-",
observed_2013_2016$Day, " ",
observed_2013_2016$Hour, ":",
observed_2013_2016$Minute, sep=""),
tz ="UTC")

target_2013_2016$time = as.POSIXct(
paste(target_2013_2016$Year, "-",
target_2013_2016$Month, "-",
target_2013_2016$Day, " ",
target_2013_2016$Hour, ":",
target_2013_2016$Minute, sep=""),
tz ="UTC")

\donttest{

 # Apply the site adaptation procedure
   site_adapted_series = site_adapt(
   Target = target_2013_2016,
   latitude_target = -23.5614, # Latitude of target site
   z_target = 407.0, # Elevation of target site
   Calibration = calibration_2016,
   latitude_calibrat = -23.5614, # Same location of target period
   z_calibrat = 407.0, # Same location of target period
   timezone = "UTC",
   GHI_threshold = -99, # The threshold is calculated from observed data
   DNI_threshold = -99) # The threshold is calculated from observed data


# Load measured data for evaluating the site adaptation performance:
   data(observed_2013_2016)

# Merge datasets

site_adapted_series$time = as.POSIXct(
paste(site_adapted_series$Year, "-",
site_adapted_series$Month, "-",
site_adapted_series$Day, " ",
site_adapted_series$Hour, ":",
site_adapted_series$Minute, sep=""),
tz ="UTC")

meas_model = merge(observed_2013_2016[,6:9],
target_2013_2016[,c(6:9,11)],
by = "time", all = FALSE )

meas_model_adapt = merge(meas_model,
site_adapted_series[,6:10],
by = "time", all = FALSE )


# Display scatterplots
library(RColorBrewer)
pal <- rev(brewer.pal(11,"Spectral"))
pal=pal[2:11]

library(ggplot2)
scatter_DNI.obs = ggplot() +
geom_hex(data=meas_model_adapt,aes(x=DNI.obs, y = DNI.mod),bins = 125, alpha = 1) +
scale_fill_gradientn(colours = pal)+ theme_light() +
xlab(expression(paste("Measured DNI (W / ", m^2, " )", sep=""))) +
 ylab(expression(paste("Modeled DNI (W / ", m^2, " )", sep=""))) +
 theme(legend.position = "none") +
 xlim(100, 1120) + ylim(100,1120) +
geom_abline(intercept = 0, slope = 1, color="purple", linetype="solid", size=1.5, alpha = 0.5)

plot_DNI_adapt = ggplot() +
geom_hex(data=meas_model_adapt,aes(x=DNI.obs, y = DNI_adapted),bins = 125, alpha = 1) +
 scale_fill_gradientn(colours = pal)+ theme_light() +
 xlab(expression(paste("Measured DNI (W / ", m^2, " )", sep=""))) +
 ylab(expression(paste("Adapted DNI (W / ", m^2, " )", sep=""))) +
 theme(legend.position = "none") + xlim(100, 1120) + ylim(100,1120) +
 geom_abline(intercept = 0, slope = 1, color="purple", linetype="solid", size=1.5, alpha = 0.5)

library(ggpubr)
ggarrange(scatter_DNI.obs, plot_DNI_adapt)

scatter_GHI.obs = ggplot() +
geom_hex(data=meas_model_adapt,aes(x=GHI.obs, y = GHI.mod),bins = 125, alpha = 1) +
 scale_fill_gradientn(colours = pal)+ theme_light() +
 xlab(expression(paste("Measured GHI (W / ", m^2, " )", sep=""))) +
 ylab(expression(paste("Modeled GHI (W / ", m^2, " )", sep=""))) +
 theme(legend.position = "none") + xlim(100, 1180) + ylim(100,1180) +
 geom_abline(intercept = 0, slope = 1, color="purple", linetype="solid", size=1.5, alpha = 0.5)

plot_GHI_adapt = ggplot() +
geom_hex(data=meas_model_adapt,aes(x=GHI.obs, y = GHI_adapted),bins = 125, alpha = 1) +
 scale_fill_gradientn(colours = pal) + theme_light() +
 xlab(expression(paste("Measured GHI (W / ", m^2, " )", sep=""))) +
 ylab(expression(paste("Adapted GHI (W / ", m^2, " )", sep=""))) +
 theme(legend.position = "none") + xlim(100, 1180) + ylim(100,1180) +
 geom_abline(intercept = 0, slope = 1, color="purple", linetype="solid", size=1.5, alpha = 0.5)
ggarrange(scatter_GHI.obs, plot_GHI_adapt)

scatter_DHI.obs = ggplot() +
geom_hex(data=meas_model_adapt,aes(x=DHI.obs, y = DHI.mod),bins = 125, alpha = 1) +
 scale_fill_gradientn(colours = pal)+ theme_light() +
 xlab(expression(paste("Measured DHI (W / ", m^2, " )", sep=""))) +
 ylab(expression(paste("Modeled DHI (W / ", m^2, " )", sep=""))) +
 theme(legend.position = "none") + xlim(25, 700) + ylim(25, 700) +
 geom_abline(intercept = 0, slope = 1, color="purple", linetype="solid", size=1.5, alpha = 0.5)

plot_DHI_adapt = ggplot() +
geom_hex(data=meas_model_adapt,aes(x=DHI.obs, y = DHI_adapted),bins = 125, alpha = 1) +
 scale_fill_gradientn(colours = pal)+ theme_light() +
 xlab(expression(paste("Measured DHI (W / ", m^2, " )", sep=""))) +
 ylab(expression(paste("Adapted DHI (W / ", m^2, " )", sep=""))) +
 theme(legend.position = "none") + xlim(25, 700) + ylim(25, 700) +
 geom_abline(intercept = 0, slope = 1, color="purple", linetype="solid", size=1.5, alpha = 0.5)
ggarrange(scatter_DHI.obs, plot_DHI_adapt)




 # Display ECDF plots
plot_ECDF_DNI = ggplot(data=meas_model_adapt[which(meas_model_adapt$Elev > 0),])+
 stat_ecdf(aes(DNI.obs), col="firebrick", lwd = 0.75) +
 stat_ecdf(aes(DNI.mod), col="dodgerblue", lwd = 0.75) +
 stat_ecdf(aes(DNI_adapted), col="purple", lwd = 0.75) +
 theme_light() + xlab(expression(paste("DNI (W / ", m^2, " )", sep="")))+ ylab("ECDF ( - )")+
 annotate("text", x = 50, y = 0.9, label = "Measured", col="firebrick1", size = 4)+
 annotate("text", x = 50, y = 0.8, label = "Modeled", col="dodgerblue", size = 4)+
 annotate("text", x = 50, y = 0.7, label = "Adapted", col="purple", size = 4)
plot_ECDF_DNI

plot_ECDF_GHI = ggplot(data=meas_model_adapt[which(meas_model_adapt$Elev > 0),])+
 stat_ecdf(aes(GHI.obs), col="firebrick", lwd = 0.75) +
 stat_ecdf(aes(GHI.mod), col="dodgerblue", lwd = 0.75) +
 stat_ecdf(aes(GHI_adapted), col="purple", lwd = 0.75) +
 theme_light() + xlab(expression(paste("GHI (W / ", m^2, " )", sep="")))+ ylab("ECDF ( - )")+
 annotate("text", x = 50, y = 0.9, label = "Measured", col="firebrick1", size = 4)+
 annotate("text", x = 50, y = 0.8, label = "Modeled", col="dodgerblue", size = 4)+
 annotate("text", x = 50, y = 0.7, label = "Adapted", col="purple", size = 4)
plot_ECDF_GHI

plot_ECDF_DHI = ggplot(data=meas_model_adapt[which(meas_model_adapt$Elev > 0),])+
 stat_ecdf(aes(DHI.obs), col="firebrick", lwd = 0.75) +
 stat_ecdf(aes(DHI.mod), col="dodgerblue", lwd = 0.75) +
 stat_ecdf(aes(DHI_adapted), col="purple", lwd = 0.75) +
 theme_light() + xlab(expression(paste("DHI (W / ", m^2, " )", sep="")))+ylab("ECDF ( - )")+
 annotate("text", x = 25, y = 0.9, label = "Measured", col="firebrick1", size = 4)+
 annotate("text", x = 25, y = 0.8, label = "Modeled", col="dodgerblue", size = 4)+
 annotate("text", x = 25, y = 0.7, label = "Adapted", col="purple", size = 4)
plot_ECDF_DHI




# Statistical indicators
library(hydroGOF)
pbias(meas_model_adapt$GHI.mod,meas_model_adapt$GHI.obs)
pbias(meas_model_adapt$GHI_adapted,meas_model_adapt$GHI.obs)

pbias(meas_model_adapt$DNI.mod,meas_model_adapt$DNI.obs)
pbias(meas_model_adapt$DNI_adapted,meas_model_adapt$DNI.obs)

pbias(meas_model_adapt$DHI.mod,meas_model_adapt$DHI.obs)
pbias(meas_model_adapt$DHI_adapted,meas_model_adapt$DHI.obs)

rmse(meas_model_adapt$GHI.mod,meas_model_adapt$GHI.obs)
rmse(meas_model_adapt$GHI_adapted,meas_model_adapt$GHI.obs)

rmse(meas_model_adapt$DNI.mod,meas_model_adapt$DNI.obs)
rmse(meas_model_adapt$DNI_adapted,meas_model_adapt$DNI.obs)

rmse(meas_model_adapt$DHI.mod,meas_model_adapt$DHI.obs)
rmse(meas_model_adapt$DHI_adapted,meas_model_adapt$DHI.obs)}



}
