% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcuheritability.R
\name{get.noise.var}
\alias{get.noise.var}
\title{Suggestion noise}
\usage{
get.noise.var(gene.coef, freq, heritability, Dskim = 0, ...)
}
\arguments{
\item{gene.coef}{a list including the coefficients of genetic effects.
Each element includes 8 genetic parameters (regression
coefficient)
\eqn{\beta_{Gw_{t}}}, t in (1, 2, \eqn{\cdots}{...}, 8)}

\item{freq}{a dataframe with the allele frequencies.}

\item{heritability}{expected heritability.}

\item{Dskim}{the coefficient of linkage disequilibrium. Default is 0 (no LD).}

\item{...}{not used.}
}
\value{
variance of noise to generate the random noise.
}
\description{
Give suggestion on the parameter setting of noise variance according to the expected heritability.
}
\examples{
get.noise.var(gene.coefficients, allele.freq, 0.5)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}

