% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcuheritability.R
\name{calc.gene.var}
\alias{calc.gene.var}
\title{Genetic Variance}
\usage{
calc.gene.var(gene.coef, freq, Dskim = 0, ...)
}
\arguments{
\item{gene.coef}{a list with the coefficients of genetic effects.
Each element includes 8 genetic parameters (regression
coefficient)
\eqn{\beta_{Gw_{t}}}{\beta_Gwt}, t in (1, 2, \eqn{\cdots}{...}, 8)}

\item{freq}{a dataframe with the allele frequencies.}

\item{Dskim}{the coefficient of linkage disequilibrium. Default is 0 (no LD).}

\item{...}{not used.}
}
\value{
genetic variance.
}
\description{
Calculate the total genetic variance
}
\details{
The genetic variance is calculated based on the genetic parameters
\eqn{\beta_{Gw_{t}}}{\beta_Gwt}, t in (1, 2, \eqn{\cdots}{...}, 8).

as described in the publications by Kao and Cockerham:\cr \cr

Kao CH, Zeng ZB. Modeling epistasis of quantitative trait loci using Cockerham's model. Genetics. 2002 Mar 1;160(3):1243-61. \cr
\url{http://www.genetics.org/content/160/3/1243.short} \cr \cr

Cockerham CC, Weir BS. Quadratic analyses of reciprocal crosses. Biometrics. 1977 Mar 1:187-203. \cr
\url{http://www.jstor.org/stable/2529312}
}
\examples{
calc.gene.var(gene.coefficients, allele.freq)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}

