% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{v0<-}
\alias{v0<-}
\alias{v0<-,SimInf_model-method}
\title{Update the initial continuous state v0 in each node}
\usage{
v0(model) <- value

\S4method{v0}{SimInf_model}(model) <- value
}
\arguments{
\item{model}{The model to update the initial continuous state
\code{v0}.}

\item{value}{A \code{data.frame} with the initial continuosu state in
each node. Each row is one node, and the number of rows in
\code{v0} must match the number of nodes in \code{model}. Only
the columns in \code{v0} with a name that matches a continuous
state in \code{v0} in the \code{model} will be used.}
}
\description{
Update the initial continuous state v0 in each node
}
\examples{
## Create an 'SISe' model with no infected individuals and no
## infectious pressure (phi = 0, epsilon = 0).
model <- SISe(u0 = data.frame(S = 100, I = 0), tspan = 1:100,
              phi = 0, upsilon = 0.02, gamma = 0.1, alpha = 1,
              epsilon = 0, beta_t1 = 0.15, beta_t2 = 0.15,
              beta_t3 = 0.15, beta_t4 = 0.15, end_t1 = 91,
              end_t2 = 182, end_t3 = 273, end_t4 = 365)

## Run the 'SISe' model and plot the result.
set.seed(22)
result <- run(model)
plot(result)

## Update the infectious pressure 'phi' in 'v0' and run
## the model again.
v0(model) <- data.frame(phi = 1)
result <- run(model)
plot(result)
}
