% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/model_builder.R
\docType{methods}
\name{C_code}
\alias{C_code}
\alias{C_code,SimInf_mparse,missing-method}
\alias{C_code,SimInf_mparse,character-method}
\title{Extract the C code from an \code{mparse} object}
\usage{
C_code(model, pkg)

\S4method{C_code}{SimInf_mparse,missing}(model)

\S4method{C_code}{SimInf_mparse,character}(model, pkg)
}
\arguments{
\item{model}{The \code{mparse} object to extract the C code from.}

\item{pkg}{Character vector. If the C could should be used in a
package named \code{pkg}, the function modifies the C code to
facilitate adding the code to the package. Default is to not
use this argument and return the C code unmodified.}
}
\value{
Character vector with C code for the model.
}
\description{
Extract the C code from an \code{mparse} object
}
\examples{
## Use the model parser to create a 'SimInf_mparse' object that
## expresses an SIR model, where 'b' is the transmission rate and
## 'g' is the recovery rate.
m <- mparse(c("S -> b*S*I/(S+I+R) -> I", "I -> g*I -> R"),
            c("S", "I", "R"), b = 0.16, g = 0.077)

## View the C code.
C_code(m)

## Modify the C code for a package named "XYZ"
C_code(m, "XYZ")
}
\keyword{methods}
