% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_eff.R
\name{predict_eff}
\alias{predict_eff}
\title{Prediction of effective equilibrium}
\usage{
predict_eff(E_ini_fun,B_fun,A_fun,correl_fun, tol=0.00000001)
}
\arguments{
\item{E_ini_fun}{Numeric vector of initial concentrations}

\item{B_fun}{Numeric vector of global co-regulation coefficients. Same length as \code{E_ini_fun}.}

\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{tol}{Tolerance for function \code{\link[stats]{uniroot}}}
}
\value{
List of three elements:
\itemize{
\item \code{$pred_e}: numeric vector of relative concentrations at effective equilibrium. Same length as \code{A_fun}
\item \code{$pred_tau}: numeric value of driving variable \emph{tau} at effective equilibrium
\item \code{$pred_E}: numeric vector of absolute concentrations at effective equilibrium. Same length as \code{A_fun}
}
}
\description{
Gives the effective equilibrium for relative concentrations
}
\details{
Gives values at effective equilibrium for relative concentrations and corresponding driving variable \eqn{\tau}.
This equilibrium corresponds to null derivative of relative concentrations, with a maximum for flux.

Effective equilibrium is found by searching the zero for response coefficients.
The R function uses in this objective is \code{\link[stats]{uniroot}}.

Note that sum of \code{1/B_fun} need to be equal to 1.

When there are regulation groups, preferably use \code{\link{predict_grp}}.
}
\section{Special results}{

In case of independence (\code{correl_fun="SC"}) or positive regulation (\code{correl_fun="RegPos"}), there is no effective equilibrium, and function \code{predict_eff} stops.

In case of competition (\code{correl_fun="Comp"}), effective and theoretical equilibria are confounded. Function \code{predict_eff} also stops, so use preferably function \code{\link{predict_th}} to compute equilibrium.

If \code{E_ini_fun} is a multiple of \code{1/B_fun}, effective equilibrium is confounded with theoretical equilibrium and initial point (see \code{\link{droites}} for details).
Function \code{predict_eff} returns \code{E_ini_fun} for \code{$pred_E} and 0 for \code{$pred_tau}, with a warning message.
}

\examples{
###### In presence of competition plus regulation
A <- c(1,10,30)
E0 <- c(30,30,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- apply(beta,1,sumbis) 

eq_eff <- predict_eff(E0,B,A,"CRPos")

eq_eff$pred_e
eq_eff$pred_tau
eq_eff$pred_E


}
\references{
Coton et al. (2021)
}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.

Use function \code{\link{is.correl.authorized}} to see allowed constraints for \code{correl_fun}.

Use function \code{\link{predict_th}} to compute theoretical equilibrium.

Use function \code{\link{predict_grp}} to predict equilibria when there are co-regulation groups.
}
