% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{EDR}
\alias{EDR}
\title{Compute the empirical detection rate for Type I errors and Power}
\usage{
EDR(p, alpha = 0.05)
}
\arguments{
\item{p}{a \code{numeric} vector or \code{matrix}/\code{data.frame} of p-values from the
desired statistical estimator. If a \code{matrix}, each statistic must be organized by
column, where the number of rows is equal to the number of replications}

\item{alpha}{the nominal detection rate to be studied (typical values are .10, .05, and .01). Default
is .05}
}
\description{
Computes the detection rate for determining empirical Type I error and power rates using information
from p-values.
}
\examples{

rates <- numeric(100)
for(i in 1:100){
   dat <- rnorm(100)
   rates[i] <- t.test(dat)$p.value
}

EDR(rates)
EDR(rates, alpha = .01)

# multiple rates at once
rates <- cbind(runif(1000), runif(1000))
EDR(rates)

}
\seealso{
\code{\link{ECR}}
}

