% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{analyse}
\alias{analyse}
\title{Compute estimates and statistics}
\usage{
analyse(condition, dat, fixed_design_elements = NULL, parameters = NULL)
}
\arguments{
\item{condition}{a single row from the design input (as a data.frame), indicating the
simulation conditions}

\item{dat}{the 'dat' object returned from the \code{\link{generate}} function (usually a data.frame, matrix,
or vector) if a list was returned, otherwise just the raw object defined from \code{\link{generate}}}

\item{fixed_design_elements}{object passed down from \code{\link{runSimulation}}}

\item{parameters}{the (optional) list object named 'parameters' returned from the
\code{\link{generate}} function when a list is returned. Otherwise, this will be an empty list}
}
\value{
returns a named numeric vector with the values of interest (e.g., p-values,
  effects sizes, etc), or a list containing values of interest (e.g., separate matrix
  and vector of parameter estimates corresponding to elements in \code{parameters})
}
\description{
Computes all relevant test statistics, parameter estimates, detection rates, and so on.
This is the computational heavy lifting portion of the Monte Carlo simulation.
In some cases, it may be easier to change
the output to a named list containing different parameter configurations (i.e., when
determining RMSE values for a large set of population parameters).
}
\details{
Be sure to make heavy use
of \code{\link{try}} combinations and throw a \code{\link{stop}}/\code{\link{check_error}}
if an iterative function fails
to converge. This will cause the function to stop, and \code{\link{generate}} will be called again
to obtain a different dataset.
}
\examples{
\dontrun{

myanalyse <- function(condition, dat, fixed_design_elements = NULL, parameters = NULL){

    # require packages/define functions if needed, or better yet index with the :: operator
    require(stats)
    mygreatfunction <- function(x) print('Do some stuff')

    #wrap computational statistics in try() statements to control estimation problems
    welch <- try(t.test(DV ~ group, dat), silent=TRUE)
    ind <- try(stats::t.test(DV ~ group, dat, var.equal=TRUE), silent=TRUE)

    # check if error, and if so stop and return an 'error'. This will re-draw the data
    if(is(welch, 'try-error')) stop('Welch error message')
    if(is(ind, 'try-error')) stop('Independent t-test error message')

    # In this function the p values for the t-tests are returned,
    #  and make sure to name each element, for future reference
    ret <- c(welch = welch$p.value,
             independent = ind$p.value)

    return(ret)
}

}
}
\seealso{
\code{\link{try}}, \code{\link{check_error}}, \code{\link{stop}}
}

