% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{check_error}
\alias{check_error}
\title{Check if object contains an error and stop flow}
\usage{
check_error(...)
}
\arguments{
\item{...}{objects that have been returned from a \code{\link{try}} call}
}
\description{
Check if the supplied object, which has previously been wrapped in a \code{\link{try}} function,
contains an error. If so, this function will throw an error to stop the workflow.
}
\examples{
\dontrun{

fun <- function(x) x + 1

res <- try(fun(1), silent = TRUE)
check_error(res) # no error thrown

res <- try(fun('this'), silent = TRUE)
check_error(res) # throws error

# multiple error check
res2 <- try(fun('that'), silent = TRUE)
check_error(res, res2)
}
}

