\name{rtransfam}
\alias{rtransfam}
\title{
Simulating Correlated Continuous Random Variables Using The Li Hammond Method
}
\description{
This function generates correlated continuous random variables with given univariate marginal distributions and specified correlation structure.
}
\usage{
rtransfam(R = R, cor.matrix = cor.matrix, distr = "normal")
}
\arguments{
  \item{R}{
an integer for the sample size.
}
  \item{cor.matrix}{
a correlation matrix describing the correlation structure of the standard multivariate normal distribution. 
}
  \item{distr}{
\code{"normal"} or \code{"logistic"} or \code{"extreme"} or \code{"cauchy"}.
}
}
\details{
Checks are made to ensure that \code{cor.matrix} is a valid semi-positive correlation matrix. The semi-positiveness of \code{cor.matrix} is determined by the eigenvalues.
}
\value{
Returns \code{R} correlated random vectors with \code{distr} univariate marginal distributions.  
}
\references{
Li, S.T. and Hammond, J.L. (1975). Generation of pseudorandom numbers with specified univariate distributions and correlation coefficients.
Systems, Man and Cybernetics, IEEE Transacions on 5, pp 557-561.
}
\author{
Anestis Touloumis
}
\note{
The correlation matrix \code{cor.matrix} corresponds to the correlation matrix of the standard multivariate normal distribution. With this parametrization, simulation of correlated cauchy random variables is feasible.
}

\examples{
\dontrun{An example with marginal univariate logistic distributions.}
set.seed(1)
logit.sim <- 
rtransfam(R = 1000, cor.matrix = toeplitz(c(1,rep(0.8,3))), distr = "logistic")
\dontrun{This is an example to illustrate the Li-Hammond method.}
set.seed(1)
norm.sim <- rmvnorm(1000, sigma = toeplitz(c(1,rep(0.8,3))))
all(logit.sim==qlogis(pnorm(norm.sim)))
}
