% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{CID.smooth}
\alias{CID.smooth}
\title{Smoothing function}
\usage{
CID.smooth(ac, dM)
}
\arguments{
\item{ac}{list containing a character vector where each element is a cell type or cell state assignment.}

\item{dM}{distance matrix (see ?CID.GetDistMat).}
}
\value{
A character vector with smoothed labels
}
\description{
\code{CID.smooth} uses k-nearest neighbors to identify cells which
correspond to a different label than the majority of their first-degree neighbors. If so,
those annotations are "smoothed."
}
\examples{
\dontrun{
# load data classified previously (see SignacFast)
P <- readRDS("celltypes.rds")
S <- readRDS("pbmcs.rds")

# get edges from default assay from Seurat object
default.assay <- Seurat::DefaultAssay(S)
edges = S@graphs[[which(grepl(paste0(default.assay, "_nn"), names(S@graphs)))]]

# get distance matrix
D = CID.GetDistMat(edges)

# smooth labels
smoothed = CID.smooth(ac = P$CellTypes, dM = D[[1]])
}
}
