% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GeneActivity}
\alias{GeneActivity}
\title{Create gene activity matrix}
\usage{
GeneActivity(
  object,
  assay = NULL,
  features = NULL,
  extend.upstream = 2000,
  extend.downstream = 0,
  biotypes = "protein_coding",
  max.width = 5e+05,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Name of assay to use. If NULL, use the default assay}

\item{features}{Genes to include. If NULL, use all protein-coding genes in
the annotations stored in the object}

\item{extend.upstream}{Number of bases to extend upstream of the TSS}

\item{extend.downstream}{Number of bases to extend downstream of the TTS}

\item{biotypes}{Gene biotypes to include. If NULL, use all biotypes in the
gene annotation.}

\item{max.width}{Maximum allowed gene width for a gene to be quantified.
Setting this parameter can avoid quantifying extremely long transcripts that
can add a relatively long amount of time. If NULL, do not filter genes based
on width.}

\item{verbose}{Display messages}

\item{...}{Additional options passed to \code{\link{FeatureMatrix}}}
}
\value{
Returns a sparse matrix
}
\description{
Compute counts per cell in gene body and promoter region.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
fragments <- CreateFragmentObject(
  path = fpath,
  cells = colnames(atac_small),
  validate.fragments = FALSE
)
Fragments(atac_small) <- fragments
GeneActivity(atac_small)
}
\concept{utilities}
