% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GetCellsInRegion}
\alias{GetCellsInRegion}
\title{Get cells in a region}
\usage{
GetCellsInRegion(tabix, region, cells = NULL)
}
\arguments{
\item{tabix}{Tabix object}

\item{region}{A string giving the region to extract from the fragments file}

\item{cells}{Vector of cells to include in output. If NULL, include all cells}
}
\value{
Returns a list
}
\description{
Extract cell names containing reads mapped within a given genomic region
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
GetCellsInRegion(tabix = fpath, region = "chr1-10245-762629")
}
\concept{utilities}
