% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{FractionCountsInRegion}
\alias{FractionCountsInRegion}
\title{FractionCountsInRegion}
\usage{
FractionCountsInRegion(object, assay, regions, sep = c("-", "-"), ...)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Name of assay to use}

\item{regions}{A GRanges object containing a set of genomic regions}

\item{sep}{The separator used to separate genomic coordinate information in the assay feature names}

\item{...}{Additional arguments passed to \code{\link{CountsInRegion}}}
}
\value{
Returns a numeric vector
}
\description{
Find the fraction of counts per cell that overlap a given set of genomic ranges
}
\examples{
FractionCountsInRegion(
  object = atac_small,
  assay = 'bins',
  regions = blacklist_hg19
)
}
