% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gDiscrim.R
\name{gDiscrim}
\alias{gDiscrim}
\title{Compute generalized item discrimination}
\usage{
gDiscrim(Data, k = 3, l = 1, u = 3, maxscore, minscore, x, ...)
}
\arguments{
\item{Data}{matrix or data.frame of items to be examined. Rows represent
respondents, columns represent items.}

\item{k}{numeric: number of groups to which may be \code{Data} divided by the
total score. Default value is 3.  See \strong{Details}.}

\item{l}{numeric: lower group. Default value is 1. See \strong{Details}.}

\item{u}{numeric: upper group. Default value is 3. See \strong{Details}.}

\item{maxscore}{numeric: maximal score in ordinal items. If missing, vector
of obtained maximal scores is imputed. See \strong{Details}.}

\item{minscore}{numeric: minimal score in ordinal items. If missing, vector
of obtained minimal scores is imputed. See \strong{Details}.}

\item{x}{deprecated. Use argument \code{Data} instead.}

\item{...}{
  Arguments passed on to \code{\link[base:findInterval]{base::findInterval}}
  \describe{
    \item{\code{rightmost.closed}}{logical; if true, the rightmost interval,
    \code{vec[N-1] .. vec[N]} is treated as \emph{closed}, see below.}
    \item{\code{all.inside}}{logical; if true, the returned indices are coerced
    into \code{1,\dots,N-1}, i.e., \code{0} is mapped to \code{1}
    and \code{N} to \code{N-1}.}
    \item{\code{left.open}}{logical; if true all the intervals are open at left
    and closed at right; in the formulas below, \eqn{\le} should be
    swapped with \eqn{<} (and \eqn{>} with \eqn{\ge}), and
    \code{rightmost.closed} means \sQuote{leftmost is closed}.  This may
    be useful, e.g., in survival analysis computations.}
  }}
}
\description{
Generalized version of discrimination index ULI. The function enumerates the
ability of an item to distinguish between individuals from upper (U) vs.
lower (L) ability groups, i.e. between respondents with high vs. low overall
score on the test. Number of groups, as well as upper and lower groups can be
specified by user. You can also manually supply the maximal and minimal
scores when the theoretical range of item score is known. Note that if the
\emph{observed} item range is zero \code{NaN} is returned.
}
\details{
The function computes total test scores for all respondents and then
divides the respondents into \code{k} groups. The lower and upper groups
are determined by \code{l} and \code{u} parameters, i.e., l-th and u-th
group where the ordering is defined by increasing total score.

In ordinal items, difficulty is calculated as difference of average score
divided by range (maximal possible score \code{maxscore} minus minimal
possible score \code{minscore} for given item).

Discrimination is calculated as difference in difficulty between upper and
lower group.
}
\note{
\code{gDiscrim} is used by \code{\link[=DDplot]{DDplot()}} function.
}
\examples{
# binary dataset
dataBin <- dataMedical[, 1:100]
# ordinal dataset
dataOrd <- dataMedicalgraded[, 1:100]

# ULI for the first 5 items of binary dataset
# compare to psychometric::discrim(dataBin)
gDiscrim(dataBin)[1:5]
# generalized ULI using 5 groups, compare 4th and 5th for binary dataset
gDiscrim(dataBin, k = 5, l = 4, u = 5)[1:5]

# ULI for first 5 items for ordinal dataset
gDiscrim(dataOrd)[1:5]
# generalized ULI using 5 groups, compare 4th and 5th for binary dataset
gDiscrim(dataOrd, k = 5, l = 4, u = 5)[1:5]
# maximum (4) and minimum (0) score are same for all items
gDiscrim(dataOrd, k = 5, l = 4, u = 5, maxscore = 4, minscore = 0)[1:5]
}
\references{
Martinkova, P., Stepanek, L., Drabinova, A., Houdek, J.,
Vejrazka, M., & Stuka, C. (2017). Semi-real-time analyses of item
characteristics for medical school admission tests. In: Proceedings of the
2017 Federated Conference on Computer Science and Information Systems.
https://doi.org/10.15439/2017F380
}
\seealso{
\code{\link[=DDplot]{DDplot()}}
}
\author{
Adela Hladka \cr Institute of Computer Science of the Czech Academy
of Sciences \cr \email{hladka@cs.cas.cz}

Lubomir Stepanek \cr Institute of Computer Science of the Czech Academy of
Sciences

Jana Vorlickova \cr Institute of Computer Science of the Czech Academy of
Sciences

Patricia Martinkova \cr Institute of Computer Science of the Czech Academy
of Sciences \cr \email{martinkova@cs.cas.cz}

Jan Netik \cr Institute of Computer Science of the Czech Academy of
Sciences \cr \email{netik@cs.cas.cz}
}
