% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_HCI.R
\docType{data}
\name{HCIlong}
\alias{HCIlong}
\title{Homeostasis Concept Inventory in a long format}
\format{
\code{HCIlong} is a \code{data.frame} consisting of 13,020 rows and 5
variables.
\describe{
\item{id}{Row number of the original observation in a wide format.}
\item{item}{Name of the item the rating is for.}
\item{rating}{Response to the item.}
\item{gender}{Gender membership, \code{"0"} males, \code{"1"} females. }
\item{major}{Identificator whether student plans to major in the life
sciences.}
\item{total}{Total score}
}
}
\usage{
HCIlong
}
\description{
\code{HCIlong} dataset consists of the dichotomously scored responses of 651
students (405 males, 246 females) to Homeostasis Concept Inventory (HCI)
multiple-choice test. It contains 20 items (\strong{in a long format}), vector of
gender membership and identificator whether students plan to major in life
sciences.
}
\references{
McFarland, J. L., Price, R. M., Wenderoth, M. P., Martinkova, P.,
Cliff, W., Michael, J., ... & Wright, A. (2017). Development and validation
of the homeostasis concept inventory. CBE-Life Sciences Education, 16(2),
ar35. \doi{10.1187/cbe.16-10-0305}
}
\seealso{
\link{HCI} for HCI dichotomous dataset (in a wide format)\cr
\link{HCItest} for HCI multiple-choice dataset\cr
\link{HCIkey} for key of correct answers for HCI\cr
\link{HCIdata} for HCI full dataset\cr
\link{HCIgrads}  for HCI dataset of graduate students\cr
\link{HCIprepost} for HCI pretest and posttest scores\cr
\link{HCItestretest} for HCI test-retest dataset\cr
}
\author{
Jenny L. McFarland \cr Biology Department, Edmonds Community College
}
\keyword{datasets}
