% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/default.R, R/assay5.R,
%   R/dimreduc.R, R/neighbor.R
\name{Cells}
\alias{Cells}
\alias{Features}
\alias{Cells.default}
\alias{Cells.Assay5}
\alias{Features.Assay5}
\alias{Cells.DimReduc}
\alias{Cells.Neighbor}
\title{Cell and Feature Names}
\usage{
Cells(x, ...)

Features(x, ...)

\method{Cells}{default}(x, ...)

\method{Cells}{Assay5}(x, layer = NULL, simplify = TRUE, ...)

\method{Features}{Assay5}(x, layer = NULL, simplify = TRUE, ...)

\method{Cells}{DimReduc}(x, ...)

\method{Cells}{Neighbor}(x, ...)
}
\arguments{
\item{x}{An object}

\item{...}{Arguments passed to other methods}

\item{layer}{Layer to pull cells/features for; defaults to default layer;
if \code{NA}, returns all cells for the assay}

\item{simplify}{Simplify the cell/feature names into a single vector; if
\code{FALSE}, separates each cell/feature names by layer}
}
\value{
\code{Cell}: A vector of cell names

\code{Features}: A vector of feature names
}
\description{
Get the cell and feature names of an object
}
\examples{
Cells(x = pbmc_small)

}
\seealso{

\code{\link{dimnames.Assay5}()},
\code{\link{dimnames.Assay}()},
\code{\link{dimnames.Seurat}()}
}
\concept{data-access}
\concept{dimnames}
