% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{FeaturePlot}
\alias{FeaturePlot}
\title{Visualize 'features' on a dimensional reduction plot}
\usage{
FeaturePlot(object, features.plot, min.cutoff = NA, max.cutoff = NA,
  dim.1 = 1, dim.2 = 2, cells.use = NULL, pt.size = 1,
  cols.use = c("yellow", "red"), pch.use = 16, overlay = FALSE,
  do.hover = FALSE, data.hover = "ident", do.identify = FALSE,
  reduction.use = "tsne", use.imputed = FALSE, nCol = NULL,
  no.axes = FALSE, no.legend = TRUE, coord.fixed = FALSE,
  dark.theme = FALSE, do.return = FALSE, vector.friendly = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{features.plot}{Vector of features to plot}

\item{min.cutoff}{Vector of minimum cutoff values for each feature, may specify quantile in the form of 'q##' where '##' is the quantile (eg, 1, 10)}

\item{max.cutoff}{Vector of maximum cutoff values for each feature, may specify quantile in the form of 'q##' where '##' is the quantile (eg, 1, 10)}

\item{dim.1}{Dimension for x-axis (default 1)}

\item{dim.2}{Dimension for y-axis (default 2)}

\item{cells.use}{Vector of cells to plot (default is all cells)}

\item{pt.size}{Adjust point size for plotting}

\item{cols.use}{The two colors to form the gradient over. Provide as string vector with
the first color corresponding to low values, the second to high. Also accepts a Brewer
color scale or vector of colors. Note: this will bin the data into number of colors provided.}

\item{pch.use}{Pch for plotting}

\item{overlay}{Plot two features overlayed one on top of the other}

\item{do.hover}{Enable hovering over points to view information}

\item{data.hover}{Data to add to the hover, pass a character vector of features to add. Defaults to cell name and identity. Pass 'NULL' to remove extra data.}

\item{do.identify}{Opens a locator session to identify clusters of cells}

\item{reduction.use}{Which dimensionality reduction to use. Default is
"tsne", can also be "pca", or "ica", assuming these are precomputed.}

\item{use.imputed}{Use imputed values for gene expression (default is FALSE)}

\item{nCol}{Number of columns to use when plotting multiple features.}

\item{no.axes}{Remove axis labels}

\item{no.legend}{Remove legend from the graph. Default is TRUE.}

\item{coord.fixed}{Use a fixed scale coordinate system (for spatial coordinates). Default is FALSE.}

\item{dark.theme}{Plot in a dark theme}

\item{do.return}{return the ggplot2 object}

\item{vector.friendly}{FALSE by default. If TRUE, points are flattened into a PNG, while axes/labels retain full vector resolution. Useful for producing AI-friendly plots with large numbers of cells.}
}
\value{
No return value, only a graphical output
}
\description{
Colors single cells on a dimensional reduction plot according to a 'feature'
(i.e. gene expression, PC scores, number of genes detected, etc.)
}
\examples{
FeaturePlot(object = pbmc_small, features.plot = 'PC1')

}
