% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceSpikeSlab.R
\name{SSS_discretize_Lambda_beta}
\alias{SSS_discretize_Lambda_beta}
\title{Given prior Lambda=Beta(kappa,lambda) on the alpha-parameter in the
spike-and-slab model, make a discretized version of Lambda that is only
supported on a grid of approximately m * sqrt(n) discrete values of alpha.
This discretized version of Lambda is required as input for
SSS_discrete_spike_slab.}
\usage{
SSS_discretize_Lambda_beta(m = 20, n, kappa, lambda)
}
\arguments{
\item{m}{A multiplier for the number of discretization points}

\item{n}{The sample size}

\item{kappa}{Parameter of the prior. Needs to be at least 0.5.}

\item{lambda}{Parameter of the prior. Needs to be at least 0.5.}
}
\value{
List (alpha_grid, log_probs), where alpha_grid is a vector with the
generated grid points, and log_probs are the logs of the prior probabilities
of these grid points for the discretized Lambda prior.
}
\description{
Given prior Lambda=Beta(kappa,lambda) on the alpha-parameter in the
spike-and-slab model, make a discretized version of Lambda that is only
supported on a grid of approximately m * sqrt(n) discrete values of alpha.
This discretized version of Lambda is required as input for
SSS_discrete_spike_slab.
}
