% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{SeqDesign}
\alias{SeqDesign}
\title{A Sequential Design}
\description{
An R6 Class encapsulating the data and functionality for a sequential experimental design.
This class takes care of data intialization and sequential assignments. The class object
should be saved securely after each assignment e.g. on an encrypted cloud server.
}
\examples{

## ------------------------------------------------
## Method `SeqDesign$new`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 100, p = 10, design = "KK21stepwise")
 

## ------------------------------------------------
## Method `SeqDesign$add_subject_to_experiment`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 100, p = 10, design = "CRD")
seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))


## ------------------------------------------------
## Method `SeqDesign$print_current_subject_assignment`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 100, p = 10, design = "CRD")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))
seq_des$print_current_subject_assignment()


## ------------------------------------------------
## Method `SeqDesign$add_current_subject_response`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 100, p = 10, design = "KK21")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

seq_des$add_current_subject_response(4.71)


## ------------------------------------------------
## Method `SeqDesign$add_all_subject_responses`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 6, p = 10, design = "CRD")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))
				

## ------------------------------------------------
## Method `SeqDesign$matching_statistics`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 6, p = 10, design = "KK14")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))

seq_des$matching_statistics()


## ------------------------------------------------
## Method `SeqDesign$assert_experiment_completed`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 6, p = 10, design = "CRD")
seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

#if run, it would throw an error since all of the covariate vectors are not yet recorded
#seq_des$assert_experiment_completed() 

seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

#if run, it would throw an error since the responses are not yet recorded
#seq_des$assert_experiment_completed() 

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))

seq_des$assert_experiment_completed() #no response means the assert is true

## ------------------------------------------------
## Method `SeqDesign$check_experiment_completed`
## ------------------------------------------------

seq_des = SeqDesign$new(n = 6, p = 10, design = "CRD")
seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

#returns FALSE since all of the covariate vectors are not yet recorded
seq_des$check_experiment_completed() 

seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

#returns FALSE since the responses are not yet recorded
seq_des$check_experiment_completed() 

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))

seq_des$check_experiment_completed() #returns TRUE

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{t}}{The current number of subjects in this sequential experiment (begins at zero).}

\item{\code{design}}{The type of sequential experimental design (see constructor's documentation).}

\item{\code{X}}{A numeric matrix of subject data with number of rows n (the number of subjects) and number of 
columns p (the number of characteristics measured for each subject). This matrix is filled in
sequentially and thus will have data present for rows 1...t (i.e. the number of subjects in the
experiment currently) but otherwise will be missing.}

\item{\code{y}}{A numeric vector of subject responses with number of entries n (the number of subjects). During
the KK21 designs this must be filled in sequentially (similar to X) and will have data present for
entries 1...t (i.e. the number of subjects in the experiment currently) but otherwise will be missing.
For non-KK21 designs, this vector can be set at anytime (but must be set before inference is desired).}

\item{\code{w}}{A binary vector of subject assignments with number of entries n (the number of subjects). 
This vector is filled in sequentially (similar to X) and will have assignments present for
entries 1...t (i.e. the number of subjects in the experiment currently) but otherwise will be missing.}

\item{\code{verbose}}{A flag that indicates whether messages should be displayed to the user}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SeqDesign$new()}}
\item \href{#method-add_subject_to_experiment}{\code{SeqDesign$add_subject_to_experiment()}}
\item \href{#method-print_current_subject_assignment}{\code{SeqDesign$print_current_subject_assignment()}}
\item \href{#method-add_current_subject_response}{\code{SeqDesign$add_current_subject_response()}}
\item \href{#method-add_all_subject_responses}{\code{SeqDesign$add_all_subject_responses()}}
\item \href{#method-matching_statistics}{\code{SeqDesign$matching_statistics()}}
\item \href{#method-assert_experiment_completed}{\code{SeqDesign$assert_experiment_completed()}}
\item \href{#method-check_experiment_completed}{\code{SeqDesign$check_experiment_completed()}}
\item \href{#method-clone}{\code{SeqDesign$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a sequential experimental design
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$new(n, p, design, verbose = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of subjects fixed beforehand. A future version of this software will allow
for sequential stopping and thus n will not need to be prespecified.}

\item{\code{p}}{Number of characteristics measured for each subject. If measurement j are 
categorical with L_j levels, you must select a reference level and convert this information
to L_j-1 dummies. Thus p := # of numeric variables + sum_j (L_j - 1).}

\item{\code{design}}{The type of sequential experimental design. This must be one of the following
"CRD" for the completely randomized design / Bernoulli design, 
"BCRD" for the balanaced completely randomized design with n/2 T's and n/2 C's,
"Efron" for Efron's (1971) Biased Coin Design
"Atkinson" for Atkinson's (1982) Covariate-Adjusted Biased Coin Design
"KK14" for Kapelner and Krieger's (2014) Covariate-Adjusted Matching on the Fly Design
"KK21" for Kapelner and Krieger's (2021) CARA Matching on the Fly with Differential Covariate Weights Design
"KK21stepwise" for Kapelner and Krieger's (2021) CARA Matching on the Fly with Differential Covariate Weights Stepwise Design}

\item{\code{verbose}}{A flag indicating whether messages should be displayed to the user. Default is \code{TRUE}.}

\item{\code{...}}{Design-specific parameters:
"Efron" requires "weighted_coin_prob" which is the probability of the weighted coin for assignment. If unspecified, default is 2/3.
All "KK" designs require "lambda", the quantile cutoff of the subject distance distribution for determining matches. If unspecified, default is 10%.
All "KK" designs require "t_0_pct", the percentage of total sample size n where matching begins. If unspecified, default is 35%.
All "KK21" designs further require "num_boot" which is the number of bootstrap samples taken to approximate the subject-distance distribution. If unspecified, default is 500.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `SeqDesign` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 100, p = 10, design = "KK21stepwise")
 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_subject_to_experiment"></a>}}
\if{latex}{\out{\hypertarget{method-add_subject_to_experiment}{}}}
\subsection{Method \code{add_subject_to_experiment()}}{
Add subject-specific measurements for the next subject entrant
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$add_subject_to_experiment(x_vec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_vec}}{A p-length numeric vector}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 100, p = 10, design = "CRD")
seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print_current_subject_assignment"></a>}}
\if{latex}{\out{\hypertarget{method-print_current_subject_assignment}{}}}
\subsection{Method \code{print_current_subject_assignment()}}{
Prints the current assignment to screen. Should be called after \code{add_subject_to_experiment}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$print_current_subject_assignment()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 100, p = 10, design = "CRD")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))
seq_des$print_current_subject_assignment()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_current_subject_response"></a>}}
\if{latex}{\out{\hypertarget{method-add_current_subject_response}{}}}
\subsection{Method \code{add_current_subject_response()}}{
For CARA designs, add subject response for the current subject entrant
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$add_current_subject_response(y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{The response as a numeric scalar}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 100, p = 10, design = "KK21")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

seq_des$add_current_subject_response(4.71)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_all_subject_responses"></a>}}
\if{latex}{\out{\hypertarget{method-add_all_subject_responses}{}}}
\subsection{Method \code{add_all_subject_responses()}}{
For non-CARA designs, add all subject responses
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$add_all_subject_responses(y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{The responses as a numeric vector of length n}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 6, p = 10, design = "CRD")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))
				
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-matching_statistics"></a>}}
\if{latex}{\out{\hypertarget{method-matching_statistics}{}}}
\subsection{Method \code{matching_statistics()}}{
For KK designs only, this returns a list with useful matching statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$matching_statistics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the following data: \code{num_matches}, \code{prop_subjects_matched}, 
			\code{num_subjects_remaining_in_reservoir}, \code{prop_subjects_remaining_in_reservoir}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 6, p = 10, design = "KK14")

seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))

seq_des$matching_statistics()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assert_experiment_completed"></a>}}
\if{latex}{\out{\hypertarget{method-assert_experiment_completed}{}}}
\subsection{Method \code{assert_experiment_completed()}}{
Asserts if the experiment is completed (all n assignments are assigned
in the w vector and all n responses in the y vector are recorded), i.e. throws 
descriptive error if the experiment is incomplete.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$assert_experiment_completed()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 6, p = 10, design = "CRD")
seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

#if run, it would throw an error since all of the covariate vectors are not yet recorded
#seq_des$assert_experiment_completed() 

seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

#if run, it would throw an error since the responses are not yet recorded
#seq_des$assert_experiment_completed() 

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))

seq_des$assert_experiment_completed() #no response means the assert is true
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_experiment_completed"></a>}}
\if{latex}{\out{\hypertarget{method-check_experiment_completed}{}}}
\subsection{Method \code{check_experiment_completed()}}{
Checks if the experiment is completed (all n assignments are assigned
in the w vector and all n responses in the y vector are recorded).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$check_experiment_completed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if experiment is complete, \code{FALSE} otherwise.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{seq_des = SeqDesign$new(n = 6, p = 10, design = "CRD")
seq_des$add_subject_to_experiment(c(1, 38, 142, 71, 5.3, 0, 0, 0, 1, 0))

#returns FALSE since all of the covariate vectors are not yet recorded
seq_des$check_experiment_completed() 

seq_des$add_subject_to_experiment(c(0, 27, 127, 60, 5.5, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 42, 169, 74, 5.1, 0, 1, 0, 0, 0))
seq_des$add_subject_to_experiment(c(0, 59, 105, 62, 5.9, 0, 0, 0, 1, 0))
seq_des$add_subject_to_experiment(c(1, 32, 186, 66, 5.6, 1, 0, 0, 0, 0))
seq_des$add_subject_to_experiment(c(1, 37, 178, 75, 6.5, 0, 0, 0, 0, 1))

#returns FALSE since the responses are not yet recorded
seq_des$check_experiment_completed() 

seq_des$add_all_subject_responses(c(4.71, 1.23, 4.78, 6.11, 5.95, 8.43))

seq_des$check_experiment_completed() #returns TRUE

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeqDesign$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
