% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectvarsda.R
\name{selectvarsda}
\alias{selectvarsda}
\title{Selecting variables for the SDA model}
\usage{
selectvarsda(y, xlist)
}
\arguments{
\item{y}{A vector of a response variable}

\item{xlist}{A list of the SDA explanatory variables}
}
\value{
A list of the selected the second dimension variables
}
\description{
Function for selecting variables for
the second deminsion of spatial association (SDA) model
}
\examples{
data("obs")
data("sample_vars_sda")
obs$Cr_ppm <- log(obs$Cr_ppm)
krm <- rmvoutlier(obs$Cr_ppm)
y <- obs$Cr_ppm[-krm]
x <- list(sample_vars_sda[[1]][-krm, 1:11])
system.time({ # ~0.01s
  sx <- selectvarsda(y, xlist = x)
})
}
