% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{climatology_ens_forecast}
\alias{climatology_ens_forecast}
\title{Returns a leave-one-year-out climatology-based ensemble forecast}
\usage{
climatology_ens_forecast(obs_dt, by = setdiff(dimvars(obs_dt), "year"))
}
\arguments{
\item{obs_dt}{Data table containing observations, must contain a column 'year'.}

\item{by}{character vector containing the column names of the grouping variables, e.g. \code{c('month','lon','lat')}.}
}
\value{
Long data table with the typical ensemble-forecast looks, i.e. containing a column 'member'.
}
\description{
for a given year, the ensemble forecast simply consists of the observations in all other years.
This is essentially an auxiliary function for computing skill scores relative to climatology.
}
\examples{
\donttest{
dt = climatology_ens_forecast(chirps_monthly)
}

}
