% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencies.dea_stoch.R
\name{efficiencies.dea_stoch}
\alias{efficiencies.dea_stoch}
\title{Objective scores}
\usage{
\method{efficiencies}{dea_stoch}(x, ...)
}
\arguments{
\item{x}{Object of class \code{dea_stoch} obtained with some of the stochastic DEA
\code{modelstoch_*} functions.}

\item{...}{Other options (for compatibility reasons)}
}
\value{
A matrix with the scores (optimal objective values).
}
\description{
Extract the scores (optimal objective values) of the evaluated
DMUs from a stochastic DEA solution.
Note that these scores may not always be interpreted as efficiencies.
}
\examples{
\donttest{
# Example 1.
library(deaR)
data("Coll_Blasco_2006")
ni <- 2 # number of inputs
no <- 2 # number of outputs
data_example <- make_deadata(datadea = Coll_Blasco_2006,
                             ni = ni,
                             no = no)
nd <- length(data_example$dmunames) # number of DMUs
var_input <- matrix(1, nrow = ni, ncol = nd)
var_output <- matrix(1, nrow = no, ncol = nd)
data_stoch <- make_deadata_stoch(datadea = data_example,
                                 var_input = var_input,
                                 var_output = var_output)
Collstoch <- modelstoch_radial(data_stoch)
efficiencies(Collstoch)
}

}
\author{
\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

University of Valencia (Spain)
}
