% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DISTRIBUTIONS.R
\encoding{UTF-8}
\name{binompdf}
\alias{binompdf}
\title{Binomial probability density function}
\usage{
binompdf(n, p, x)
}
\arguments{
\item{n}{the number of trials.}

\item{p}{a vector of probabilities.}

\item{x}{the number of success.}
}
\description{
Computes the binomial pdf at each of the values in \code{x} using the corresponding number of trials in \code{n} and probability of success for each trial in \code{p}.
}
\note{
The probability density function (pdf) is given by: \deqn{p(x) = {n \choose k} p^x (1 - p)^{n - x}}{p(x) = choose(n,x) p^x (1-p)^(n-x)} with \eqn{x = 0, 1, 2, \dots}
}
\examples{
trials = 10
prob = c(.2,.25,.3,.35)
success = 4
binomcdf(n = trials, p = prob, x = success)
}

