% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rstack}
\alias{rstack}
\title{Stacked Table With Correlations}
\usage{
rstack(m)
}
\arguments{
\item{m}{is a square matrix}
}
\value{
An table or a data.frame containing correlations for \code{m}
}
\description{
Pearson's product-moment coefficient is the well known degree to which two or more variables are linearly associated. In a two-dimensional table, the degree of correlation among the variables is quantified by the correlation coefficient.
}
\details{
The function generates a flatten table of correlations. If necessary, typing \sQuote{cor(t(x))} will coerce \sQuote{x} properly to a square matrix format.
}
\note{
When using the function to correlate values of a variable with corresponding values at a different time will lead to an autocorrelation table.
}
\examples{
data(nerlove63)
(table <- rprob(nerlove63) )
rstack(table)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Spiegel, M. R. (1992) Correlation Theory. in: \emph{Theory and Problems of Probability and Statistics,} 2nd ed. New York: McGraw-Hill, pp. 294--323.
}
\seealso{
\code{\link{rprob}}
}
\keyword{Descriptive}
\keyword{Tables}

