% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saferank.R
\name{testAdditions}
\alias{testAdditions}
\title{Test the sensitivity of a result to tactical voting.}
\usage{
testAdditions(
  votes,
  ainc = 1,
  arep = NULL,
  favoured = NULL,
  tacticalBallot = NULL,
  rankMethod = "safeRank",
  countMethod = "stv",
  countArgs = list(),
  exptName = NULL,
  equiet = FALSE,
  everbose = FALSE
)
}
\arguments{
\item{votes}{A set of ballots, as in
\href{https://CRAN.R-project.org/package=vote}{vote_2.3.2}}

\item{ainc}{Number of ballots to be added in each step}

\item{arep}{Maximum number of ballot-stuffed elections to run}

\item{favoured}{Name of the candidate being "plumped".  If \code{NULL}, a random
candidate is selected from among the candidates not initially top-ranked.
All other candidates are fully-ranked at random, with an identical ballot
paper being stuffed multiple times.  An integer value for \code{favoured} is
interpreted as an index into the candidate names.}

\item{tacticalBallot}{A ballot paper i.e. a vector of length \code{ncol(ballots)}.
If this argument is non-\code{NULL}, it takes precedence over \code{favoured} when the
ballot box is being stuffed.}

\item{rankMethod}{"safeRank" (default), "elected", or "rank".  "rank" is
a total ranking of the candidates, with ties broken at random.  "elected"
assigns rank=1 to elected candidates, rank=2 for eliminated candidates.}

\item{countMethod}{countMethod "stv" (default) or "condorcet"}

\item{countArgs}{List of args to be passed to countMethod (in addition to
votes)}

\item{exptName}{stem-name of experimental units \emph{e.g.} "E".  If \code{NULL}, then
a 3-character string of capital letters is chosen at random.}

\item{equiet}{\code{TRUE} to suppress all experimental output}

\item{everbose}{\code{TRUE} to produce diagnostic output from the experiment}
}
\value{
A matrix of experimental results, of dimension \eqn{n} by \eqn{2m+1},
where \eqn{n} is the number of elections and \eqn{m} is the number of
candidates.  The first column is named "nBallots".  Other columns indicate
the ranking of the eponymous candidate, and their margin over the
next-lower-ranked candidate.
}
\description{
Ballots are added until a specified number of simulated elections (\code{arep})
have been held.   If a \code{favoured} candidate is specified, then the ballot-box
is stuffed with ballots awarding first-preference to this candidate.
Alternatively, a \code{tacticalBallot} may be specified.  If both \code{favoured} and
\code{tacticalBallot} are \code{NULL}, then a random candidate is selected as the
favoured one.
}
\examples{
data(food_election) 
testAdditions(food_election, arep = 2, favoured = "Strawberries", 
  countArgs = list(safety = 0))

}
