% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printsvmmaj.R, R/svmmaj.R
\name{print.q.svmmaj}
\alias{print.q.svmmaj}
\alias{svmmaj}
\alias{svmmaj.default}
\title{SVM-Maj Algorithm}
\usage{
\method{print}{q.svmmaj}(x, ...)

svmmaj(
  X,
  y,
  lambda = 1,
  weights.obs = 1,
  weights.var = 1,
  scale = c("interval", "zscore", "none"),
  spline.knots = 0,
  spline.degree = 1L,
  kernel = vanilladot,
  kernel.sigma = 1,
  kernel.scale = 1,
  kernel.degree = 1,
  kernel.offset = 1,
  hinge = c("absolute", "quadratic", "huber", "logitistic"),
  hinge.delta = 1e-08,
  options = setSVMoptions(),
  initial.point = NULL,
  verbose = FALSE,
  na.action = na.omit,
  ...
)

\method{svmmaj}{default}(
  X,
  y,
  lambda = 1,
  weights.obs = 1,
  weights.var = 1,
  scale = c("interval", "zscore", "none"),
  spline.knots = 0,
  spline.degree = 1L,
  kernel = vanilladot,
  kernel.sigma = 1,
  kernel.scale = 1,
  kernel.degree = 1,
  kernel.offset = 1,
  hinge = c("absolute", "quadratic", "huber", "logitistic"),
  hinge.delta = 1e-08,
  options = setSVMoptions(),
  initial.point = NULL,
  verbose = FALSE,
  na.action = na.omit,
  ...
)
}
\arguments{
\item{x}{the \code{svmmaj} object as result of \code{\link[SVMMaj]{svmmaj}}}

\item{...}{Other arguments passed to methods.}

\item{X}{A data frame (or object coercible by
\code{\link[base]{as.data.frame}} to a data frame) consisting the attributes,
the class of each attribute can be either \code{numeric}, \code{logical} or
\code{factor}.}

\item{y}{A factor (or object coercible by \code{\link[base]{factor}} to a
factor) consisting the class labels.}

\item{lambda}{Regularization parameter of the penalty term.}

\item{weights.obs}{a vector of length \code{n} with the nonnegative weight 
for the residual of each object (with length \code{n}).  If the length is
 \code{2}, then it specifies the weight per class.}

\item{weights.var}{a vector of length \code{k} with weights for each
attribute.}

\item{scale}{Specifies whether the columns of attribute matrix \code{X}
needs to be standardized into zscores or to the interval \code{[0 1]}.
Possible values are: \code{none}, \code{zscore} and \code{interval}.
Moreover, the standardization parameters can be given instead.}

\item{spline.knots}{equals the number of internal knots of the spline basis. 
  When the number of knots exceeds the number of (categorical) values of 
  an explanatory variable, the duplicate knots will be removed using 
\code{\link[base]{unique}}. For no splines, use \code{spline.knots = 0}.}

\item{spline.degree}{equals the polynomial degree of the splines, 
for no splines:\code{spline.degree = 1}.}

\item{kernel}{Specifies which kernel function to be used (see
\code{\link[kernlab]{dots}} of package \pkg{kernlab}). 
Default kernel is the linear kernel.}

\item{kernel.sigma}{additional parameters used for the kernel function
(see \code{\link[kernlab]{dots}})}

\item{kernel.scale}{additional parameters used for the kernel function
(see \code{\link[kernlab]{dots}})}

\item{kernel.degree}{additional parameters used for the kernel function
(see \code{\link[kernlab]{dots}})}

\item{kernel.offset}{additional parameters used for the kernel function
(see \code{\link[kernlab]{dots}})}

\item{hinge}{Specifies with hinge function from 
\code{\link[SVMMaj]{getHinge}} should be used.}

\item{hinge.delta}{The parameter of the huber hinge 
(only if \code{hinge = 'huber'}).}

\item{options}{additional settings used in the \code{svmmaj} algorithm}

\item{initial.point}{Initial solution.}

\item{verbose}{\code{TRUE} shows the progress of the
iteration.}

\item{na.action}{Generic function for handling NA values.}
}
\value{
Returns a svmmaj-class object, 
  of which the methods \code{plot},
  \code{plotWeights}, \code{summary} and \code{predict} can be applied.  
  (see also \code{\link[SVMMaj]{predict.svmmaj}} and 
  \code{\link[SVMMaj]{print.svmmaj}})
}
\description{
SVM-Maj is an algorithm to compute a support vector machine (SVM) solution.
In its most simple form, it aims at finding hyperplane that optimally
separates two given classes.  This objective is equivalent to finding a
linear combination of \code{k} predictor variables to predict the two
classes for \code{n} observations.  SVM-Maj minimizes the standard support
vector machine (SVM) loss function.  The algorithm uses three efficient
updates for three different situations: primal method which is efficient in
the case of \code{n > k}, the decomposition method, used when the matrix of
predictor variables is not of full rank, and a dual method, that is
efficient when \code{n < k}.  Apart from the standard absolute hinge error,
SVM-Maj can also handle the quadratic and the Huber hinge.
}
\details{
The following settings can be added as element in the \code{options} 
parameter:
\code{decomposition} Specifies whether the QR decomposition should be used
for efficient updates. Possible values are \code{'svd'} for Singular value 
decomposition (Eigenvalue decomposition for non-linear kernel) or 
\code{'chol'} for Cholesky (or QR decomposition in case of linear kernel)

\code{convergence} Specifies the convergence criterion of the algorithm.
Default is \code{1e-08}.
\code{increase.step} The iteration number from which relaxed update will be
used.
\code{eps} The relaxation of the majorization function for absolute hinge:
\code{.25 * eps^-1} is the maximum steepness of the majorization function.

\code{check.positive} Specifies whether a check has to be made for positive
input values.
\code{max.iter} maximum number of iterations to use
}
\examples{

## using default settings
model1 <- svmmaj(
 diabetes$X, diabetes$y, hinge = 'quadratic', lambda = 1)
summary(model1)

weights.obs = list(positive = 2, negative = 1)
## using radial basis kernel
library(kernlab)
model2 <- svmmaj(
  diabetes$X, diabetes$y, hinge = 'quadratic', lambda = 1, 
  weights.obs = weights.obs, scale = 'interval',
  kernel = rbfdot,
  kernel.sigma = 1
)
summary(model2)
## I-spline basis
library(ggplot2)
model3 <- svmmaj(
  diabetes$X, diabetes$y, weight.obs = weight.obs,
  spline.knots = 3, spline.degree = 2
)
plotWeights(model3, plotdim = c(2, 4))
}
\references{
P.J.F. Groenen, G. Nalbantov and J.C. Bioch (2008)
     \emph{SVM-Maj: a majorization approach to linear support vector machines 
     with different hinge errors.}
}
\seealso{
\code{\link[kernlab]{dots}} for the computations of the kernels.
     \code{\link[SVMMaj]{predict.svmmaj}} 
     \code{\link[SVMMaj]{normalize}}
     \code{\link[SVMMaj]{isb}} 
     \code{\link[SVMMaj]{getHinge}}
}
\author{
Hok San Yip, Patrick J.F. Groenen, Georgi Nalbantov
}
