% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_osm_batch.R
\name{geocode_osm_batch}
\alias{geocode_osm_batch}
\title{Batch geocode addresses with OpenStreetMap}
\usage{
geocode_osm_batch(
  query,
  delay = 1,
  return_all = FALSE,
  match_num = 1,
  details = FALSE,
  user_agent = NULL,
  verbose = FALSE
)
}
\arguments{
\item{query}{Addresses or place names to be geocoded. Character string.}

\item{delay}{Delay between requests. Default is 1 second. Numeric.}

\item{return_all}{Should all matches be returned? Overrides \code{match_num} if \code{TRUE}. Default is \code{FALSE}. Logical.}

\item{match_num}{If query matches multiple locations, which match to return? Default is 1 (highest-ranking match, by relevance). Numeric.}

\item{details}{Should detailed results be returned? Default is \code{FALSE}. Logical.}

\item{user_agent}{Valid User-Agent identifying the application for OSM-Nominatum. If none supplied, function will attempt to auto-detect. Character string.}

\item{verbose}{Print status messages and progress? Default is \code{FALSE}. Logical.}
}
\value{
A \code{data.frame} object. If \code{details=FALSE}, contains fields
\itemize{
 \item "query". User-supplied address query(ies). Character string.
 \item "osm_id". OpenStreetMap ID. Character string.
 \item "address". OpenStreetMap address. Character string.
 \item "longitude". Horizontal coordinate. Numeric.
 \item "latitude". Vertical coordinate. Numeric.
 }
If \code{details=TRUE}, contains additional fields
\itemize{
 \item "osm_type". OpenStreetMap ID. Character string.
 \item "importance". Relevance of Nominatum match to query, from 0 (worst) to 1 (best). Numeric.
 \item "bbox_ymin". Minimum vertical coordinate of bounding box. Numeric.
 \item "bbox_ymax". Maximum vertical coordinate of bounding box. Numeric.
 \item "bbox_xmin". Minimum horizontal coordinate of bounding box. Numeric.
 \item "bbox_xmax". Maximum horizontal coordinate of bounding box. Numeric.
 }
}
\description{
Function to find geographic coordinates of multiple addresses and place names, using OpenStreetMap's Nominatum API.
}
\details{
Wrapper function for \code{\link[SUNGEO]{geocode_osm}}. Because Nominatim Usage Policy stipulates an absolute maximum of 1 request per second, this function facilitates batch geocoding by adding a small delay between queries (\url{https://operations.osmfoundation.org/policies/nominatim/}).
}
\examples{
# Geocode multiple addresses (top matches only)
\dontrun{
geocode_osm_batch(c("Ann Arbor","East Lansing","Columbus"))
}
# With progress reports
\dontrun{
geocode_osm_batch(c("Ann Arbor","East Lansing","Columbus"), verbose = TRUE)
}
# Return detailed results for all matches
\dontrun{
geocode_osm_batch(c("Ann Arbor","East Lansing","Columbus"),
                  details = TRUE, return_all = TRUE)
}
}
