% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitspace.R
\name{fitSpace}
\alias{fitSpace}
\title{Fit INLA models to perform simple space smoothing.}
\usage{
fitSpace(data, geo, Amat, family, responseVar, strataVar = "strata",
  weightVar = "weights", regionVar = "region", clusterVar = "~v001+v002",
  hyper = NULL, hyper.besag = c(0.5, 5e-05), hyper.iid = c(0.5, 5e-05),
  CI = 0.95, FUN = NULL)
}
\arguments{
\item{data}{data frame with region and strata information.}

\item{geo}{Geo file}

\item{Amat}{Adjacency matrix for the regions}

\item{family}{Link function specification, currently supports 'binomial' (default with logit link function) or 'gaussian'.}

\item{responseVar}{the response variable}

\item{strataVar}{the strata variable}

\item{weightVar}{the weights variable}

\item{regionVar}{Variable name for region, typically 'v024', for older surveys might be 'v101'}

\item{clusterVar}{Variable name for cluster, typically '~v001 + v002'}

\item{hyper}{the vector of two hyper parameters if specified by user}

\item{hyper.besag}{the vector of two hyper parameters for the structured spatial random effects in Gaussian model, if specified by user}

\item{hyper.iid}{the vector of two hyper parameters for the unstructured spatial random effects in Gaussian model, if specified by user}

\item{CI}{the desired posterior credible interval to calculate}

\item{FUN}{the function to transform the posterior draws. Default to be identify function for normal variable and inverse logit transformation for binomial variables}
}
\value{
\item{HT}{Direct estimates}
\item{smooth}{Spatially smoothed estimates}
\item{fit}{a fitted INLA object}
\item{geo}{input argument}
\item{Amat}{input argument}
\item{CI}{input argument}
\item{family}{input argument}
\item{FUN}{input argument}
}
\description{
This function calculates the direct estimates by region and fit a simple spatial smoothing model to the direct estimates adjusting for survey design.
}
\details{
Normal or binary variables are currently supported. For binary variables, the logit transformation is performed on the direct estimates of probabilities, and a Gaussian additive model is fitted on the logit scale using INLA.
}
\examples{
\dontrun{
data(DemoData2)
data(DemoMap2)
fit <- fitSpace(data=DemoData2, geo=DemoMap2$geo, 
Amat=DemoMap2$Amat, family="binomial", 
responseVar="tobacco.use", strataVar="strata", 
weightVar="weights", regionVar="region", 
clusterVar = "~clustid+id", 
hyper=NULL, CI = 0.95)
}
}
\seealso{
\code{\link{countrySummary_mult}}, \code{\link{fitINLA}}
}
