% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-perc-1RM.R
\name{get_perc_1RM}
\alias{get_perc_1RM}
\title{Get \%1RM}
\usage{
get_perc_1RM(reps, method = "RIR", model = "epley", ...)
}
\arguments{
\item{reps}{Numeric vector. Number of repetition to be performed}

\item{method}{Character vector. Default is "RIR". Other options are
"DI", "RelInt", "\%MR"}

\item{model}{Character vector. Default is "epley". Other options are
"modified epley", "linear"}

\item{...}{Forwarded to selected \code{adj_perc_1RM} function}
}
\value{
Numeric vector. Predicted \%1RM
}
\description{
Function \code{get_perc_1RM} represent a wrapper function
}
\examples{
get_perc_1RM(5)

# # Use ballistic adjustment (this implies doing half the reps)
get_perc_1RM(5, mfactor = 2)

# Use perc MR adjustment method
get_perc_1RM(5, "\%MR", adjustment = 0.8)

# Use linear model with use defined klin values
get_perc_1RM(5, "\%MR", model = "linear", adjustment = 0.8, klin = 36)
}
