% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.SSN2}
\alias{fitted.SSN2}
\alias{fitted.ssn_lm}
\alias{fitted.values.ssn_lm}
\alias{fitted.ssn_glm}
\alias{fitted.values.ssn_glm}
\title{Extract model fitted values}
\usage{
\method{fitted}{ssn_lm}(object, type = "response", ...)

\method{fitted.values}{ssn_lm}(object, type = "response", ...)

\method{fitted}{ssn_glm}(object, type = "response", ...)

\method{fitted.values}{ssn_glm}(object, type = "response", ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{type}{\code{"response"} for fitted values of the response,
\code{"tailup"} for fitted values of the tailup random errors,
\code{"taildown"} for fitted values of the taildown random errors,
\code{"euclid"} for fitted values of the Euclidean random errors,
\code{"nugget"} for fitted values of the nugget random errors,
or \code{"randcov"} for fitted values of the random effects. If from
\code{\link[=ssn_glm]{ssn_glm()}}, \code{"link"} for fitted values on the link scale.
The default is \code{"response"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The fitted values according to \code{type}.
}
\description{
Extract fitted values from fitted model objects. \code{fitted.values}
is an alias.
}
\details{
When \code{type} is \code{"response"}, the fitted values
for each observation are the standard fitted values \eqn{X \hat{\beta}}.
When \code{type} is \code{"tailup"}, \code{"taildown"}, \code{"euclid"},
or \code{"nugget"} the fitted values for each observation
are (generally) the best linear unbiased predictors of the respective random error.
When \code{type} is \code{"randcov"}, the fitted
values for each level of each random effect are (generally) the best linear unbiased
predictors of the corresponding random effect. The fitted values for \code{type}
\code{"tailup"}, \code{"taildown"}, \code{"euclid"},
\code{"nugget"}, and \code{"randcov"} can generally be used to check assumptions
for each component of the fitted model object (e.g., check a Gaussian assumption).

If from \code{\link[=ssn_glm]{ssn_glm()}}, when \code{type} is \code{"response"}, the fitted values
for each observation are the standard fitted values on the inverse link
scale: \eqn{g^{-1}}(\eqn{X \hat{\beta} + \nu}), where \eqn{g(.)} is a link function,
\eqn{\beta} are the fixed effects, and \eqn{\nu} are the spatial and random effects.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
fitted(ssn_mod)
fitted.values(ssn_mod)
}
