% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_constraints_clustering.R
\name{ckmeansSSLR}
\alias{ckmeansSSLR}
\title{General Interface COP K-Means Algorithm}
\usage{
ckmeansSSLR(n_clusters = NULL, mustLink = NULL, cantLink = NULL, max_iter = 10)
}
\arguments{
\item{n_clusters}{A number of clusters to be considered. Default is NULL (num classes)}

\item{mustLink}{A list of must-link constraints. NULL Default, constrints same label}

\item{cantLink}{A list of cannot-link constraints. NULL Default, constrints with different label}

\item{max_iter}{maximum iterations in KMeans. Default is 10}
}
\description{
Model from conclust \cr
This function takes an unlabeled dataset and two lists of must-link and cannot-link constraints
as input and produce a clustering as output.
}
\note{
This models only returns labels, not centers
}
\examples{
library(tidyverse)
library(caret)
library(SSLR)
library(tidymodels)

data <- iris

set.seed(1)
#\% LABELED
cls <- which(colnames(iris) == "Species")

labeled.index <- createDataPartition(data$Species, p = .2, list = FALSE)
data[-labeled.index,cls] <- NA


m <- ckmeansSSLR() \%>\% fit(Species ~ ., data)

#Get labels (assing clusters), type = "raw" return factor
labels <- m \%>\% cluster_labels()

print(labels)


}
\references{
Wagstaff, Cardie, Rogers, Schrodl\cr
\emph{Constrained K-means Clustering with Background Knowledge}\cr
2001
}
