% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tritraining.R
\name{triTraining}
\alias{triTraining}
\title{General Interface for Tri-training model}
\usage{
triTraining(learner)
}
\arguments{
\item{learner}{model from parsnip package for training a supervised base classifier
using a set of instances. This model need to have probability predictions
(or optionally a distance matrix) and it's corresponding classes.}
}
\value{
A list object of class "triTraining" containing:
\describe{
\item{model}{The final three base classifiers trained using the enlarged labeled set.}
\item{model.index}{List of three vectors of indexes related to the training instances
used per each classifier. These indexes are relative to the \code{y} argument.}
\item{instances.index}{The indexes of all training instances used to
train the three models. These indexes include the initial labeled instances
and the newly labeled instances. These indexes are relative to the \code{y} argument.}
\item{model.index.map}{List of three vectors with the same information in \code{model.index}
but the indexes are relative to \code{instances.index} vector.}
\item{classes}{The levels of \code{y} factor.}
\item{pred}{The function provided in the \code{pred} argument.}
\item{pred.pars}{The list provided in the \code{pred.pars} argument.}
\item{x.inst}{The value provided in the \code{x.inst} argument.}
}
}
\description{
Tri-training is a semi-supervised learning algorithm with a co-training
style. This algorithm trains three classifiers with the same learning scheme from a
reduced set of labeled examples. For each iteration, an unlabeled example is labeled
for a classifier if the other two classifiers agree on the labeling proposed.
}
\details{
Tri-training initiates the self-labeling process by training three models from the
original labeled set, using the \code{learner} function specified.
In each iteration, the algorithm detects unlabeled examples on which two classifiers
agree with the classification and includes these instances in the enlarged set of the
third classifier under certain conditions. The generation of the final hypothesis is
produced via the majority voting. The iteration process ends when no changes occur in
any model during a complete iteration.
}
\examples{
library(tidyverse)
library(tidymodels)
library(caret)
library(SSLR)

data(wine)

set.seed(1)
train.index <- createDataPartition(wine$Wine, p = .7, list = FALSE)
train <- wine[ train.index,]
test  <- wine[-train.index,]

cls <- which(colnames(wine) == "Wine")

#\% LABELED
labeled.index <- createDataPartition(wine$Wine, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA

#We need a model with probability predictions from parsnip
#https://tidymodels.github.io/parsnip/articles/articles/Models.html
#It should be with mode = classification

#For example, with Random Forest
rf <-  rand_forest(trees = 100, mode = "classification") \%>\%
  set_engine("randomForest")


m <- triTraining(learner = rf) \%>\% fit(Wine ~ ., data = train)


#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Wine", estimate = .pred_class)
}
\references{
ZhiHua Zhou and Ming Li.\cr
\emph{Tri-training: exploiting unlabeled data using three classifiers.}\cr
IEEE Transactions on Knowledge and Data Engineering, 17(11):1529-1541, Nov 2005. ISSN 1041-4347. doi: 10.1109/TKDE.2005. 186.
}
