% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DummyDuplicated.R
\name{DummyDuplicated}
\alias{DummyDuplicated}
\alias{XprodRnd}
\title{Duplicated columns in dummy matrix}
\usage{
DummyDuplicated(x, idx = FALSE, rows = FALSE, rnd = FALSE)

XprodRnd(x, duplic = TRUE, idx = FALSE, rows = FALSE, seed = NULL)
}
\arguments{
\item{x}{A matrix}

\item{idx}{Indices returned when TRUE}

\item{rows}{Duplicated rows instead when TRUE}

\item{rnd}{Algorithm based on cross product with random numbers when TRUE (dummy matrix not required)}

\item{duplic}{XprodRnd parameter: When \code{duplic} and \code{idx} are \code{FALSE}, this function returns \code{crossprod(x,u)} or \code{x\%*\%u} instead of indices or duplicated.}

\item{seed}{XprodRnd parameter: Seed to be used. When NULL the ordinary random value stream in R continues.}
}
\value{
Logical vectors specifying duplicated columns or vector of indices (first match)
}
\description{
The algorithm is based on \code{crossprod(x)} or \code{crossprod(x, u)} where \code{u} is a vector of random numbers
}
\details{
The efficiency of the default algorithm depends on the sparsity of \code{crossprod(x)}.
The random values are generated locally within the function without affecting the random value stream in R.
}
\note{
\code{DummyDuplicated} calls \code{XprodRnd} with \code{123} as seed when \code{rnd} is \code{TRUE}.
\code{XprodRnd} performs three runs with different random numbers.
A warning is produced if one deviates. Error occurs if all three are different.
}
\examples{
x <- cbind(1, rbind(diag(2), diag(2)), diag(4)[, 1:2])
z <- Matrix(x[c(1:4, 2:3), c(1, 2, 1:5, 5, 2)])

DummyDuplicated(z)
which(DummyDuplicated(z, rows = TRUE))

# Four ways to obtain the same result
DummyDuplicated(z, idx = TRUE)
DummyDuplicated(z, idx = TRUE, rnd = TRUE)
DummyDuplicated(t(z), idx = TRUE, rows = TRUE)
DummyDuplicated(t(z), idx = TRUE, rows = TRUE, rnd = TRUE)

# The unique values in four ways 
which(!DummyDuplicated(z), )
which(!DummyDuplicated(z, rnd = TRUE))
which(!DummyDuplicated(t(z), rows = TRUE))
which(!DummyDuplicated(t(z), rows = TRUE, rnd = TRUE))
}
\author{
Øyvind Langsrud
}
